%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: Continuous Sensor Placement. IEEE Signal Processing Letters, 22(5): 544-548, May 2015.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: Aug 2014
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all; clc;
delta = 0.05;
x = 0:delta:10; lx = length(x);

% f1 = [0.1 0.33 0.67 0.78 0.95].';
% f2 = [0.15 0.772 0.434 0.67 0.88].';%[0.15 0.7 0.4 0.58 0.85].';
% alpha1 = [0.5 0.65 0.3 -0.15 0.45].';
% alpha2 = [-0.25 -0.33 -0.6 0.95 -0.25].';%[0.5 -0.33 0.6 -0.95 -0.25].';

f1 = [0.1 0.33 0.67 0.78 0.95].';
f2 = [0.15 0.7 0.4 0.58 0.85].';
alpha1 = [0.5 0.65 0.3 -0.15 0.45].';
alpha2 = [0.5 -0.33 0.6 -0.95 -0.25].';


thr=zeros(2,2);
for ii = 1:lx
%     a1(ii) = sum(alpha1.* exp(1j*2*pi*f1*x(ii)));
%     a2(ii) = sum(alpha2.* exp(1j*2*pi*f2*x(ii)));
    a1(ii) = sum(alpha1.* sin(2*pi*f1*x(ii)));
    a2(ii) = sum(alpha2.* sin(2*pi*f2*x(ii)));
    thr = thr + [a1(ii);a2(ii)]*[a1(ii);a2(ii)]';
    
end
thr_sc = trace(inv(thr));

%%
close all;
am1 = zeros(lx,1);
am2 = zeros(lx,1);
for ii = 1:lx
    %am(ii) = sum(alpha.* exp(1j*2*pi*f*xm(ii)));
    am1(ii) = sum(alpha1.* sin(2*pi*f1*x(ii)));
    am2(ii) = sum(alpha2.* sin(2*pi*f2*x(ii)));
end

Am = [am1 am2];

%
cvx_solver sedumi
cvx_begin sdp
variable w(lx)
expression ai;
Ai=zeros(2,2);
for m=1:lx
    Ai = Ai + w(m)* Am(m,:)'*Am(m,:); 
end
%minimize sum(w) 
minimize trace_inv(Ai)
subject to
%trace_inv(Ai) <= (201/109.45)*thr_sc; 
sum(w) == 50;
w>=0;
w<=1;
cvx_end
MSE_finegrid = cvx_optval
time_finegrid=cvx_cputime

%% close all;
figure(10);set(gca,'Fontsize', 16);
x_axis = x; %0:1/lx:(lx-1)/lx;
h1=plot(x_axis, (a1), '--b', 'LineWidth',2,...
    'MarkerEdgeColor','k',...
    'MarkerSize',6,'DisplayName','a1(x)');
hold on;
h2=plot(x_axis, a2, '-.r', 'LineWidth',1.5,...
    'MarkerEdgeColor','r',...
    'MarkerSize',6,'DisplayName','a2(x)');

h3=stem(x_axis,w,'+k', 'LineWidth',1,...
    'MarkerEdgeColor','k',...
    'MarkerSize',6,'DisplayName','sample points');

xlabel('x [m]'); ylabel('a(x)');
x_axisNormalized = 0:1:10;
set(gca,'XTick',x_axisNormalized)
set(gca,'XTickLabel',sprintf('%1.0f|',x_axisNormalized));
box off;grid on;

hleg1= legend([h1,h2,h3],'h1(x)','h2(x)'...
             ,'Selected sensorsA'  ,'Location','Best');
         
% set(hleg1,...
%     'Position',[0.423720449172575 0.714876261773429 0.300059101654846 0.19524747645315]);

set(hleg1,...
    'Position',[0.415684734886864 0.761870309392468 0.319701958797704 0.161914143119817]);


print('-deps', 'Finegrid.eps');         
