%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: Continuous Sensor Placement. IEEE Signal Processing Letters, 22(5): 544-548, May 2015.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: Aug 2014
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all;
close all;
clc;

delta = 0.001; x_max=10;
x = 0:delta:x_max; lx = length(x);

x_axis = x; %0:1/lx:(lx-1)/lx;
x_axisNormalized = 0:1:10;

d= 5;

% f1 = [0.1 0.33 0.67 0.78 0.95].';
% f2 = [0.15 0.772 0.434 0.67 0.88].';%[0.15 0.7 0.4 0.58 0.85].';
% alpha1 = [0.5 0.65 0.3 -0.15 0.45].';
% alpha2 = [-0.25 -0.33 -0.6 0.95 -0.25].';%[0.5 -0.33 0.6 -0.95 -0.25].';

f1 = [0.1 0.33 0.67 0.78 0.95].';
f2 = [0.15 0.7 0.4 0.58 0.85].';
alpha1 = [0.5 0.65 0.3 -0.15 0.45].';
alpha2 = [0.5 -0.33 0.6 -0.95 -0.25].';


thr=zeros(2,2);
for ii = 1:length(x)
%     a1(ii) = sum(alpha1.* exp(1j*2*pi*f1*x(ii)));
%     a2(ii) = sum(alpha2.* exp(1j*2*pi*f2*x(ii)));
    a1(ii) = sum(alpha1.* sin(2*pi*f1*x(ii)));
    a2(ii) = sum(alpha2.* sin(2*pi*f2*x(ii)));
    thr = thr + [a1(ii);a2(ii)]*[a1(ii);a2(ii)]';
    
end
thr_sc = trace(inv(thr));



delta_m = 1;
xm=[0:delta_m:x_max]';

M=length(xm);
st(xm*1000+1)=1;

am1 = zeros(length(xm),1);
am2 = zeros(length(xm),1);
for ii = 1:length(xm)
    %am(ii) = sum(alpha.* exp(1j*2*pi*f*xm(ii)));
    am1(ii) = sum(alpha1.* sin(2*pi*f1*xm(ii)));
    am2(ii) = sum(alpha2.* sin(2*pi*f2*xm(ii)));
end

Am = [am1 am2];
%% Classical 
close all;

cvx_solver sedumi
cvx_begin sdp 
variable w(M)
expression ai;
Ai=zeros(2,2);
for m=1:M
    Ai = Ai + w(m)* Am(m,:)'*Am(m,:); 
end
minimize trace_inv(Ai)
subject to
 sum(w)  == 5; % (1000/0.71)*thr_sc; %(1000/0.652)*thr_sc; chooses 6 (set 1)
w>=0;
w<=1;
cvx_end

time_griddensity1 = cvx_cputime

%% close all
figure(2);set(gca,'Fontsize', 16);
h1=plot(x_axis, (a1), '--b', 'LineWidth',1.5,...
    'MarkerEdgeColor','b',...
    'MarkerSize',6,'DisplayName','|a_1(x)|');
hold on;
h2= plot(x_axis, (a2), '-.r', 'LineWidth',1.5,...
    'MarkerEdgeColor','r',...
    'MarkerSize',6,'DisplayName','|a_2(x)|');
h3= stem(xm,w,'+k', 'LineWidth',2,...
    'MarkerEdgeColor','k',...
    'MarkerSize',15,'DisplayName','sensor selection');
hold on;
xlabel('x [m]'); ylabel('a(x)');
set(gca,'XTick',x_axisNormalized)
set(gca,'XTickLabel',sprintf('%1.0f|',x_axisNormalized));
box off;grid on;
hleg1= legend([h1,h2,h3],'h1(x)','h2(x)'...
             ,'Selected sensorsA');
set(hleg1,...
    'Position',[0.410327592029722 0.727257214154372 0.319701958797704 0.19524747645315]);
         

print('-deps', 'sensorselectionTwo.eps');

%MSE: 0.4307 


%% TLS based joint sparse
%close all;

% delta_m = 1;
% xm=[0:delta_m:x_max]';
% M=length(xm);
% st(xm*1000+1)=1;

%compute the derivative
derv_am1 = zeros(length(xm),1);
derv_am2 = zeros(length(xm),1);
alpha1_aux = alpha1.*(2*pi*f1);
alpha2_aux = alpha2.*(2*pi*f2);
for ii = 1:length(xm)
    %am(ii) = sum(alpha.* exp(1j*2*pi*f*xm(ii)));
    derv_am1(ii) = sum(alpha1_aux.* cos(2*pi*f1*xm(ii)));
    derv_am2(ii) = sum(alpha2_aux.* cos(2*pi*f2*xm(ii)));
end

derv_Am = [derv_am1 derv_am2];

cvx_solver sedumi
cvx_begin sdp 
variable w(M)
variable del_w(M)
variable del_x(M)
variable W(M,M) hermitian semidefinite
expression Ai;
Ai=zeros(2,2);
for m=1:M
    Ai = Ai + w(m)* Am(m,:)'*Am(m,:) ...
        + del_w(m) * derv_Am(m,:)'*derv_Am(m,:) ...
        + del_x(m) * (Am(m,:)'*derv_Am(m,:) + derv_Am(m,:)'*Am(m,:)) ;

end
minimize (sum(norms([w,del_w,del_x],2,2)) )
subject to
trace_inv(Ai) <= (1000/4.75)*thr_sc; %(1000/4.89)*thr_sc;
w>=0;
w<=1;
[W del_x; del_x' 1]== semidefinite(M+1);
diag(W) == del_w;
for mm=1:M
   for nn=1:M
       if (mm~=nn)
       W(mm,nn) == 0;
       end
   end
 end
del_w >= 0;
del_w <= 0.25*delta_m^2;
del_x >= -0.5*delta_m;
del_x <= 0.5*delta_m;
cvx_end

time_tlsprop = cvx_cputime

wsort=sort(w); thres=wsort(M-5);
wsel_idx = find(w >thres);

wtls = nan(lx,1); 

% idx = roundn((xm+roundn(del_x,-3))*1000+1,-3);
% if (idx(M)>10000)
%     idx(M)=10000;
% end
% wtls(idx)=w;

xsel = xm + del_x; xsel = xsel([2,4,5,9,10]);
idx = roundn((roundn(xsel,-3))*1000+1,-3);
wtls(idx)=ones(5,1);

%%
figure(4);set(gca,'Fontsize', 16);
h1=plot(x_axis, (a1), '--b', 'LineWidth',1.5,...
    'MarkerEdgeColor','b',...
    'MarkerSize',6,'DisplayName','|a_1(x)|');
hold on;
h2= plot(x_axis, (a2), '-.r', 'LineWidth',1.5,...
    'MarkerEdgeColor','r',...
    'MarkerSize',6,'DisplayName','|a_2(x)|');
hold on;
h3=stem(x_axis,wtls,'ok','LineWidth',2,...
    'MarkerEdgeColor','k',...
    'MarkerSize',6,'DisplayName','corrected grid');
hold on;
% h4=stem(xm,w,'--ok','LineWidth',1.2,...
%     'MarkerEdgeColor','k',...
%     'MarkerSize',6,'DisplayName','corrected grid');

xlabel('x [m]'); ylabel('a(x)');
grid on;
box off;grid on;         
set(gca,'XTick',x_axisNormalized)
set(gca,'XTickLabel',sprintf('%1.0f|',x_axisNormalized));

hleg1= legend([h1,h2,h3],'h1(x)','h2(x)'...
             ,'proposed samplerAA');
         
set(hleg1,...
    'Position',[0.416131163458295 0.720114357011515 0.308987673083418 0.19524747645315]);


%%%
% xsel = xm + del_x; xsel = xsel([2,4,5,9,10,11])
am1sel = zeros(length(xsel),1);
am2sel = zeros(length(xsel),1);
for ii = 1:length(xsel)
%am(ii) = sum(alpha.* exp(1j*2*pi*f*xm(ii)));
am1sel(ii) = sum(alpha1.* sin(2*pi*f1*xsel(ii)));
am2sel(ii) = sum(alpha2.* sin(2*pi*f2*xsel(ii)));
end
% am1sel
% am2sel
Amsel = [am1sel, am2sel];
MSE_proposed =trace(inv(Amsel'*Amsel))
% MSE : 0.3062

print('-deps', 'TLStwo.eps');

%% without quadratic


cvx_solver sedumi
cvx_begin sdp 
variable w(M)
variable del_x(M)
expression Ai;
Ai=zeros(2,2);
for m=1:M
    Ai = Ai + w(m)* Am(m,:)'*Am(m,:) ...
        + del_x(m) * (Am(m,:)'*derv_Am(m,:) + derv_Am(m,:)'*Am(m,:)) ;

end
minimize (sum(norms([w,del_x],2,2)) )
subject to
Ai - 7.3*eye(2,2) == semidefinite(2);
w>=0;
w<=1;
del_x >= -0.2*delta_m;
del_x <= 0.2*delta_m;
cvx_end

time_tlsprop = cvx_cputime

wsort=sort(w); thres=wsort(M-5);
wsel_idx = find(w >thres);

wtls = nan(lx,1); 

idx = roundn((xm+roundn(del_x,-3))*1000+1,-3);
if (idx(M)>10000)
    idx(M)=10000;
end
wtls(idx)=w;

% xsel = xm + del_x; xsel = xsel([2,4,5,9,10]);
% idx = roundn((roundn(xsel,-3))*1000+1,-3);
% wtls(idx)=ones(5,1);


figure(5);set(gca,'Fontsize', 16);
h1=plot(x_axis, (a1), '--b', 'LineWidth',1.5,...
    'MarkerEdgeColor','b',...
    'MarkerSize',6,'DisplayName','|a_1(x)|');
hold on;
h2= plot(x_axis, (a2), '-.r', 'LineWidth',1.5,...
    'MarkerEdgeColor','r',...
    'MarkerSize',6,'DisplayName','|a_2(x)|');
hold on;
h3=stem(x_axis,wtls,'ok','LineWidth',2,...
    'MarkerEdgeColor','k',...
    'MarkerSize',6,'DisplayName','corrected grid');
hold on;
% h4=stem(xm,w,'--ok','LineWidth',1.2,...
%     'MarkerEdgeColor','k',...
%     'MarkerSize',6,'DisplayName','corrected grid');

xlabel('x [m]'); ylabel('{\bf a}(x)');
grid on;
box off;grid on;         
set(gca,'XTick',x_axisNormalized)
set(gca,'XTickLabel',sprintf('%1.0f|',x_axisNormalized));

hleg1= legend([h1,h2,h3],'a_1(x)','a_2(x)'...
             ,'proposed sensor placement');
         
set(hleg1,...
    'Position',[0.382202592029721 0.115352452249614 0.148273387369132 0.19524747645315]);

% print('-deps', 'TLStwo.eps');

xsel = xm + del_x; xsel = xsel(wsel_idx)

am1sel = zeros(length(xsel),1);
am2sel = zeros(length(xsel),1);
for ii = 1:length(xsel)
%am(ii) = sum(alpha.* exp(1j*2*pi*f*xm(ii)));
am1sel(ii) = sum(alpha1.* sin(2*pi*f1*xsel(ii)));
am2sel(ii) = sum(alpha2.* sin(2*pi*f2*xsel(ii)));
end
Amsel = [am1sel, am2sel];
M
MSE_proposed = trace(inv(Amsel'*Amsel))
         
       