clear all; close all; clc;

% Call gsp_BOX
gsp_start; gsp_reset_seed(1); rng(123);

karate_adjacency; % Load the adjacency of the Karate club network
karate_coordinates; % Load the coordinates of the Karate club network

N = size(Adj,1); % Store the number of nodes for future use
[U, E] = eig(Lap); % Get the eigenbasis of the GSO

G = gsp_graph(Adj, coord);
I = eye(N);

%% %% MINIMAL SQUARED ERROR RECONSTRUCTION
P = 5;
%Aprior = U(:,10:14); d = 10*randn(P,1);  %Un = U(:,P+1:N); %10:14 is sparse both domains
Aprior = U(:,1:5); d = 10*randn(P,1);
x = Aprior*d;
 

%plot the true graph signal
figure(1);
[auxX, auxY] = gplot(Adj,coord);
plot(auxX, auxY, '-o',  'LineWidth',1,...
                       'MarkerEdgeColor','r',...
                       'MarkerFaceColor','r',...
                       'MarkerSize',7);
hold on;
% stem3(coord(:,1),coord(:,2),x,'+k',...
%     'MarkerSize',8,'LineWidth',1.5);
stem3(coord(:,1),coord(:,2),x,'ok',...
    'MarkerSize',8,'LineWidth',2);
view(187,41);
axis off
set(gca,'FontSize',16);
print('-depsc', './figures/true_signal_subspace.eps');


% sampling and reconstruction
K = P; % No. of samples taken
S = I(:,1:K); % graph-domain sampling
% S= U*I(:,1:K);  % graph-spectral domain sampling


Ps = S*S';

xhat_ls = Aprior*inv(Aprior'*Ps*Aprior)*Aprior'*Ps*x;
fprintf('Error oblique projection %d\n',norm(xhat_ls - x, 2)/norm(x,2));

figure(2);
[auxX, auxY] = gplot(Adj,coord);
plot(auxX, auxY, '-o',  'LineWidth',1,...
                       'MarkerEdgeColor','r',...
                       'MarkerFaceColor','r',...
                       'MarkerSize',7);
hold on;
% stem3(coord(:,1),coord(:,2),x,'+k',...
%     'MarkerSize',8,'LineWidth',1.5);
stem3(coord(:,1),coord(:,2),xhat_ls,'+k',...
    'MarkerSize',8,'LineWidth',2);
view(187,41);
axis off
set(gca,'FontSize',16);
print('-depsc', './figures/ls_subspace.eps');

%% smoothness prior
% data generation
%f1 = @(c1,c2) sin((2-c1-c2),^2);
f1 = @(c1,c2) 0.5*cos((c1-c2).^2);
%f1 = @(x,y) (x-.5).^2 + (y-.5).^3 + x - y;
%f1 = @(c1,c2) sin(3*((c1-.5).^2+(c2-.5).^2));
x = f1(G.coords(:,1), G.coords(:,2));

%x = U(:,10:14)*rand(5,1);

%plot the true graph signal
figure(3);
[auxX, auxY] = gplot(Adj,coord);
plot(auxX, auxY, '-o',  'LineWidth',1,...
                       'MarkerEdgeColor','r',...
                       'MarkerFaceColor','r',...
                       'MarkerSize',7);
hold on;
% stem3(coord(:,1),coord(:,2),x,'+k',...
%     'MarkerSize',8,'LineWidth',1.5);
stem3(coord(:,1),coord(:,2),x,'ok',...
    'MarkerSize',8,'LineWidth',2);
view(95,42);
axis off
set(gca,'FontSize',16);
print('-depsc', './figures/true_signal_smooth.eps');


%
K = 15;
S = I(:,end-K+1:end); Ps = S*S';


%only smoothness prior

Atilde = inv(Lap + S*S')*S;


xhat_smooth = Atilde*pinv(S'*Atilde)*S'*x;
%figure; stem(S'*xhat_smooth -S'*x ,'or');
fprintf('Error smoothness recovery %d\n',norm(xhat_smooth - x, 2)/norm(x,2));

%
figure(4);
[auxX, auxY] = gplot(Adj,coord);
plot(auxX, auxY, '-o',  'LineWidth',1,...
                       'MarkerEdgeColor','r',...
                       'MarkerFaceColor','r',...
                       'MarkerSize',7);
hold on;

stem3(coord(:,1),coord(:,2),xhat_smooth,'+k',...
    'MarkerSize',8,'LineWidth',2);
view(95,42);
axis off

set(gca,'FontSize',16);
print('-depsc', './figures/smoothness_cons.eps');


%% Consistent recovery



select = [15,16,19,21];
x = zeros(G.N,1);
x(select) = ones(length(select),1);


%plot the true graph signal
figure(5);
[auxX, auxY] = gplot(Adj,coord);
plot(auxX, auxY, '-o',  'LineWidth',1,...
                       'MarkerEdgeColor','r',...
                       'MarkerFaceColor','r',...
                       'MarkerSize',7);
hold on;
% stem3(coord(:,1),coord(:,2),x,'+k',...
%     'MarkerSize',8,'LineWidth',1.5);
stem3(coord(:,1),coord(:,2),x,'ok',...
    'MarkerSize',8,'LineWidth',2);
view(-165,65);
axis off
set(gca,'FontSize',16);
print('-depsc', './figures/true_signal_consistent.eps');


K=7; M = K;

Iset = [11    12    13    14    16    22    27    34];
S = U*I(:,Iset); 
%S = U*I(:,1:K);
%S = U*randn(G.N,9); 
%Ur = U(:,1:M);

R = I(:,14:21);
%R = I(:,select);
Pr = R*inv(R'*R)*R';

%x= xr;
size(S'*R)
rank(S'*R)


%xhat_us = Pr*S* inv(S'*Pr*S)*S'*x;
xhat_consistent = R*pinv(S'*R)*S'*x;

fprintf('Error consistent reconstruction %d\n',norm(xhat_consistent - x, 2)/norm(x,2));
figure; stem(S'*xhat_consistent -S'*x ,'or');


%
%plot the true graph signal
figure(6);
[auxX, auxY] = gplot(Adj,coord);
plot(auxX, auxY, '-o',  'LineWidth',1,...
                       'MarkerEdgeColor','r',...
                       'MarkerFaceColor','r',...
                       'MarkerSize',7);
hold on;
stem3(coord(:,1),coord(:,2),xhat_consistent,'+k',...
    'MarkerSize',8,'LineWidth',2);
view(-168,48);
axis off
set(gca,'FontSize',16);
print('-depsc', './figures/consistent_recons.eps');



