function wsel = randomizedrounding(w,Smat, Amat,N,M,lambda,options)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: S.P. Chepuri and G. Leus. Sparsity-Promoting Sensor Selection 
%        for Non-linear Measurement Models. IEEE Trans. on Signal 
%        Processing, 63(3): 684-698, Feb. 2015.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: Sep 2013
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% randomization (rounding off)
rng(25,'v5uniform')
setsize=100;
Wrnd =[];

for count=1:setsize
          
    for m=1:M
        %if (w(m)~= 1 && w(m)~=0)
            if (rand(1,1) < w(m))
                wrnd(m) = 1;
            else
                wrnd(m)=0;
            end
        %else wrnd(m)=w(m);
        %end
    end
      
      Wrnd = [Wrnd, wrnd.'];
            
end

Wsel=[];
norm_wsel=[];
for iter=1:setsize
    count=0;
    junkcount=0;
    wtest = Wrnd(:,iter);
    for n=1:N
        F =zeros(2,2);
        
        for m=1:M
            F = F + wtest(m).*FmPassive(Smat(:,n),Amat(:,m),options);
        end
        
        if(min(eig(F))>= lambda)
            count=count+1;
        end 
    end
    
    if (count==N)
        Wsel = [Wsel wtest];
        norm_wsel = [norm_wsel norm(wtest,1)];
        %break;      
    else
        junkcount=junkcount+1;
    end
end
[optval_rnd,ind_rnd]=min(norm_wsel);
wsel = Wsel(:,ind_rnd);