%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: Sparse Sensing for Distributed Detection. IEEE Trans. on Signal 
%        Processing, 16(6): 1446-1460, Mar. 2016.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: March 2015
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all;
clc; close all;

M=15;
sigma = 1;
f=0.33;
theta1 = cos(2*pi*f.*[1:M]');
theta0 = zeros(M,1);


K= 5:1:14;
priorvec = 0.3; alpha = 0.01;
MKR = {'k', '+k'};
ind = 1;
rho = 0;


pi0 = priorvec;
pi1 = 1 - pi0;

thr = log(pi0/pi1);

for k = 1:length(K)
    
    temp_comb = nchoosek(1:M,K(k));
    
    Pe = zeros(length(temp_comb),1);  Pmd= zeros(length(temp_comb),1);
    
%     a = 1/(1-rho); b = (-rho/(1-rho))*(1/(1 + (K(k)-1)*rho));
%     Sinv_tilde = a * eye(M) + b*ones(M,M);
%     
%     for l=1:M
%         for ll=1:M
%             Q(l,ll)=theta1(l)*theta1(ll)*Sinv_tilde(l,ll);
%         end
%     end
    
    for ii=1:length(temp_comb)
        
        select=temp_comb(ii,:);
        m1 = theta1(select);
        m0 = theta0(select);
        
        
        d2 = (m1-m0)'*(m1-m0)/sigma^2;
        
        d=sqrt(d2);
        Pm = 1 - qfunc(thr/d - d2/(2*d));
        Pfa = qfunc(thr/d + d2/(2*d));
        Pe(ii) = pi1 * Pm + pi0*Pfa;
        
        thr_classical = d*qfuncinv(alpha) - d2/2;
        Pmd(ii) = 1-qfunc(thr_classical/d - d2/(2*d));
        
        
        
    end
    [Pe_opt(k), idx_aux(k)] = min(Pe);
    [Pd_opt(k), idx_aux2(k)] = min(Pmd);
    
    [Pd_worst(k), idx_random(k)] = max(Pmd);
    [Pe_worst(k), idx_random2(k)] = max(Pe);

    
    % sorting
    
    distance_measure = (theta1-theta0).^2;
    [dist_sorted, idx_sort] = sort(distance_measure, 'descend');
    wsel_idx = idx_sort(1:K(k));
    wsel_sort = zeros(M,1); wsel_sort(wsel_idx)=1; 
    
    % Pd of SenSel
    
    m1 = theta1(wsel_idx);
    m0 = theta0(wsel_idx);
    
   
    d2 = (m1-m0)'*(m1-m0)/sigma^2;
    d=sqrt(d2);
    
    Pm = 1 - qfunc(thr/d - d2/(2*d));
    Pfa = qfunc(thr/d + d2/(2*d));
    Pe_SenSel(k) = pi1 * Pm + pi0*Pfa;
    
    
    thr_classical = d*qfuncinv(alpha) - d2/2;
    Pd_Sensel(k) = 1- qfunc(thr_classical/d - d2/(2*d));
    
    
%     if K(k) == 5
%         wsel_sort = zeros(M,1); wsel_sort(wsel_idx)=1;
%         wsel_opt = zeros(M,1); wsel_opt(temp_comb(idx_aux,:))=1;
%         
%         figure(2); set(gca,'Fontsize', 16);
%         h1=stem(1:M,wsel_opt,'-+k','LineWidth',1.5,...
%             'MarkerEdgeColor','k',...
%             'MarkerSize',8,'DisplayName','optimal, brute force');
%         hold on;
%         h2=stem(1:M,wsel_sort,'-sk','LineWidth',1.5,...
%             'MarkerEdgeColor','k',...
%             'MarkerSize',10,'DisplayName','simplified, sorting');
%         
%         
% %         set(gca,'XTick',1:M);
% %         set(gca,'XTickLabel',1:M); xlim([5 14]);
%         grid on;
%         xlabel('k');  ylabel('pe');
%         hleg2= legend([h1,h2],'optimal, brute force','simplified, sorting',...
%             'Location','Best');
%         print('-deps', 'selected_sensors_K5.eps');
%         
%         
%         
%     end


    % random sampling
    
%     q=randperm(M);
%     
%    
%     % Pd of SenSel
%     
%     m1 = theta1(q(1:K(k)));
%     m0 = theta0(q(1:K(k)));
%     
%    
%     d2 = (m1-m0)'*(m1-m0)/sigma^2;
%     d=sqrt(d2);
%     
%     Pm = 1 - qfunc(thr/d - d2/(2*d));
%     Pfa = qfunc(thr/d + d2/(2*d));
%     Pe_random(k) = pi1 * Pm + pi0*Pfa;
%     
%     
%     thr_classical = d*qfuncinv(alpha) - d2/2;
%     Pd_random(k) = 1- qfunc(thr_classical/d - d2/(2*d));
   
    
end



%%
close all

Be = [Pe_opt', Pe_worst'-Pe_opt'];

Bd = [Pd_opt', Pd_worst'-Pd_opt'];

%rho = 0
figure(1); set(gca,'Fontsize', 16);
area(Be,'FaceColor',[0.6 0.6 0.6],'LineStyle','none');
set(gca,'XLim',[1 10])
set(gca,'XTick',[1:10])
set(gca,'XTickLabel',5:14); set (gca, 'Yscale', 'log');
hold on;
h1=semilogy(Pe_opt,'k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Bayes optimal (brute force)');
hold on;
h2=semilogy(Pe_SenSel,'-sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

% h21=semilogy(Pe_worst,'-k','LineWidth',1.5,...
%     'MarkerEdgeColor','k',...
%     'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');



figure(1); set(gca,'Fontsize', 16);
area(Bd,'FaceColor',[0.8 0.8 0.8], 'LineStyle','none');
set(gca,'XLim',[1 10])
set(gca,'XTick',[1:10])
set(gca,'XTickLabel',5:14); set (gca, 'Yscale', 'log');
hold on;
h3=semilogy(Pd_opt,'--k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Neyman-Pearson optimal (brute force)');
hold on;
h4=semilogy(Pd_Sensel,'--sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

% h41=semilogy(Pd_worst,'--k','LineWidth',1.5,...
%     'MarkerEdgeColor','k',...
%     'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

hold on;

% set(gca,'XTick',K);
% set(gca,'XTickLabel',K); 
%  ylim([0.01 5]);
% grid on;
xlabel('k');  ylabel('pe');
hleg2= legend([h1,h2,h3,h4],'Bayes optimal (pi0 = 0.3)','Bayes simplified, sorting (pi0 = 0.3)',...
    'Neyman-Pearson optimal (alpha = 0.01)', 'Neyman-Pearson simplified, sorting (alpha = 0.01)AAA',...
    'Location','Best');
set(hleg2,'FontSize',16)
set(gca,'Layer','top');
print('-deps', 'rho0p0.eps');




