function [wsel] = randomized_rounding_toeplitz(w,SS,K,theta);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: Sparse Sensing for Distributed Detection. IEEE Trans. on Signal 
%        Processing, 16(6): 1446-1460, Mar. 2016.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: March 2015
%
% 
%
% 
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% randomization (rounding off)
%rng(40,'v5uniform');
setsize=50;
Wrnd =[];
M= length(w); Phi = eye(M);
 
for count=1:setsize
          
    for m=1:M
        %if (w(m)~= 1 && w(m)~=0)
            if (rand(1,1) < w(m))
                wrnd(m) = 1;
            else
                wrnd(m)=0;
            end
        %else wrnd(m)=w(m);
        %end
    end
      
      Wrnd = [Wrnd, wrnd.'];
            
end

Wsel=[];
cost=[];
count=1;
for iter=1:setsize
    
    junkcount=0;
    
    wtest = Wrnd(:,iter); wtest_idx = find(wtest == 1);
    if (nnz(wtest) == K)
    Wsel = [Wsel wtest];    
    
    Phi_r=Phi(sort(wtest_idx),:);
    mvec1 = (Phi_r*theta);
            
    %snr
    snr_aux = mvec1'*inv(0.11*eye(K) + Phi_r*SS*Phi_r')*mvec1; 
    cost = [cost snr_aux];
    count = count+1;
    end
    
end
[optval_rnd,ind_rnd]=max(cost);
wsel = Wsel(:,ind_rnd);