%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Article:      Submodular Detection for Correlated Measurements
% Section:      Uncommon Mean [MonteCarlo] Larger Size
% Author:       Mario Coutino
% Affiliation:  TU Delft
% Data:         July 2017
% Conference:   TSP
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% seed rndm
rng(0);

% parameters for simulation
N = 50;
V = 1:N;

nIt = 1e2;

exSNR = nan(N, nIt);
tSNR = nan(N, nIt);
gSNR = nan(N, nIt);
cvxSNR = nan(N, nIt);
worstSNR = nan(N, nIt);

for it = 1:nIt
        try
    
        if (mod(it,10) == 0)
            fprintf('\n Iteration: %d\n',it)
        end
        % mean vectors
        theta0 = randn(N,1);
        theta1 = randn(N,1);

        % difference vector
        m = theta1 - theta0;

        % covariance matrix
        E = genCovMat(N,'rtoeplitz');

        % covariance decomposition
        [S,a,Sinv,ainv] = paramCov(E);
        
        % true cost function
        f = @(A) getSNR(m(A),E(A,A));
        F = sfo_fn_wrapper(f);
        
        fw = @(A) -f(A);
        Fw = sfo_fn_wrapper(fw);
        
        zVec = zeros(N,1);
                    
        for k = 1:N
            % convex
            cvx_begin sdp quiet
                variable w(N)
                variable t
                minimize t
                subject to
                sum(w) ==  k;
                [Sinv + ainv*diag(w), m;
                    m' , t] >= semidefinite(N+1);
                w(:)<=1;
                w(:)>=0;
            cvx_end
            
            [wsel] = randomized_rounding_toeplitz(w,S,k,theta1-theta0);
            wsel_idx = find(wsel == 1);
    
            cvxSNR(k,it) = m(wsel_idx)'*inv(E(wsel_idx,wsel_idx))*m(wsel_idx);
        end
        
        % greedy for the true cost function
        At = sfo_greedy_k(F,V,N);
        tSNR(:,it) = kSetFunctionCost(F,At');
            
        % greedy for the submodular cost function
        Ag = maxSubSNRGreedy(m,E,N);
        gSNR(:,it) = kSetFunctionCost(F,Ag');
        catch
            disp(' ')
        end
        
end
%%
% plotting
mean_TrSNR = nanmean(tSNR,2);
mean_SuSNR = nanmean(gSNR,2);
mean_CXSNR = nanmean(cvxSNR,2);
mean_SNRworst = nanmean(worstSNR,2);

pi0 = 0.3;
pi1 = 1 - pi0;

gamma_e = log(pi0/pi1);

Pe_BA = @(sw) pi1.*(1 - qfunc(gamma_e./sqrt(sw) - sw./(2.*sqrt(sw)))) + ...
    pi0.*qfunc(gamma_e./sqrt(sw) + sw./(2*sqrt(sw)));

alpha = 0.01;
gamma = qfuncinv(alpha);

thr = @(sw) sw.*qfuncinv(alpha) - sqrt(sw)./2;
P_md = @(sw) 1 - qfunc( (2.*thr(sw) - sw)./(2.*sqrt(sw)) );

close all,
matType = 1;
pl2 = semilogy(V,Pe_BA(mean_TrSNR(:,matType)),'+k','linewidth',1.1);
hold on,
pl3 = semilogy(V,Pe_BA(mean_SuSNR(:,matType)),'-dm','linewidth',1.1);
pl4 = semilogy(V,Pe_BA(mean_CXSNR(:,matType)),'-og','linewidth',1.1);

legend([pl2; pl3; pl4],...
    {'Greedy', 'Submodular Surrogate', ...
    'Convex Method'},'location','sw')

xlabel('Number of Sensors [k]')
ylabel('Probability of Error')

save('18-07-SmoothSnrComparisonRToeplitz50') %0 seed