%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Article:      Submodular Detection for Correlated Measurements
% Section:      ++When does Greedy Fail on the SNR?++
%               Comparison of Direct Greedy Method and Submodular Surrogate
%               for precision block matrices with equal off diagonal
%               elements.
% Author:       Mario Coutino
% Affiliation:  TU Delft
% Date:         July 2017
% Submission:   TSP
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all,
clear,

% parameters
N = 200;
V = 1:N;

P = zeros(N);
% ratio of (non-)calibrated sensors
ratio = 0.5;
nCalSensor = ceil(ratio*N);

% precision matrix block #1
alpha = 0.18;
alpha_vec = [1 alpha*ones(1,nCalSensor-1)];
P(1:nCalSensor, 1:nCalSensor) = toeplitz(alpha_vec);

% precision matrix block #2
alpha = 0;
alpha_vec = alpha.^(0:(N-nCalSensor-1));
    % alpha_vec = [1 alpha*ones(1,N-nCalSensor-1)];
P(nCalSensor+1:end, nCalSensor+1:end) = toeplitz(alpha_vec);
    % P(nCalSensor+1:end, nCalSensor+1:end) = eye(N-nCalSensor);

% covariance matrix
E = P\eye(N);

% uniform theta
theta = ones(N,1);

% function wrappers
 f_snr = @(A) theta(A)'*(E(A,A)\theta(A));
 F_snr = sfo_fn_wrapper(f_snr);
 
 % greedy solution
 Agrd = sfo_greedy_k(F_snr,V,N);
 valGrd = kSetFunctionCost(F_snr,Agrd');

% submodular surrogate
Asub = maxSubSNRGreedy(theta,E,N);
valSub = kSetFunctionCost(F_snr, Asub');

% exhaustive search
if N <= 16
    valExh = nan(N,1);
    for kk = 1:N
         Aexh = sfo_exhaustive_max(F_snr,V,kk);
        valExh(kk) = F_snr(Aexh);
    end
end

% plotting figure
figure,
set(gca,'fontsize',15)
p1 = plot(V,10*log10(valGrd),'--sg', 'linewidth',1.1);
hold on,
p4 = plot(V,10*log10(valSub),'--xm', 'linewidth',1.1);
if N <= 16
    p2 = plot(V, 10*log10(valExh),'-ob', 'linewidth', 1.1);
    legend([p1;p2;p4],{'Greedy SNR','Exahustive Search',...
     'Submodular Surrogate'})
else
    legend([p1;p4],{'Greedy SNR',...
     'Submodular Surrogate'})
end

xlabel('Number of Sensors [K]')
ylabel('SNR [dB]')
set(gca,'fontsize',15)