%% Comparison with Hadi Cost

N = 15;
V = 1:N;
P = 1;

theta = randn(N,P);

C_h = toeplitz([1;rand(N-1,1)]);
% C = C_h'*C_h;
C = gallery('toeppd',N);
Ci = inv(C);

kk = 6;
%% Greedy Aproaches
% generation of sampling matrix
E = eye(N);
Iw = @(A) E(:,A)*E(:,A)';

fHadi = @(A) theta'*Iw(A)*Ci*Iw(A)*theta; 
fTrue = @(A) theta(A)'*inv(C(A,A))*theta(A);
FHadi = sfo_fn_wrapper(fHadi);
FTrue = sfo_fn_wrapper(fTrue);

Aexh = sfo_exhaustive_max(FHadi,V,kk);
Agrd = sfo_greedy_k(FHadi,V,kk);
AexhTrue = sfo_exhaustive_max(FTrue,V,kk);
AgrdTrue = sfo_greedy_k(FTrue,V,kk);
%%
I = eye(N);


gamma = 10;
epsilon = 10e-3;

u = ones(N,1);
maxIt = 10;

for ll = 1:maxIt
    cvx_begin sdp quiet

        variable W(N,N) symmetric
        maximize( theta'*(W.*Ci)*theta - gamma*sum(diag(W)./u) )
        subject to
            trace(W) == kk;
            for i = 1:N
                for j = 1:N
                    0<= W(i,j) <= 1;
                end
                W(i,i) >= sum(W(i,setdiff(1:N,i)));
            end
    cvx_end

    u = diag(W) + epsilon;
    wSol = diag(W)>epsilon;
    fprintf('Num. nonzero: %d\n\n',nnz(wSol));
    
    if nnz(wSol) == kk
        break;
    end
end 

Acvx = V(wSol>0);
%% Output
fprintf('Exhaustive Search (True): %f\n\n',FTrue(AexhTrue'));
fprintf('Exhaustive Search (Hadi): %f\n\n',FTrue(Aexh'));
fprintf('Greedy Solution (Hadi): %f\n\n',FTrue(Agrd'));
fprintf('Greedy Solution (True): %f\n\n',FTrue(AgrdTrue'));
fprintf('Convex Solution: %f\n\n',FTrue(Acvx'));