clear all,
close all,

% Heart Cleveland Data Set [237 x 13 - 2 Classes]
A = heart;
clsName = renumlab(classnames(A));
clsFreq = classsizes(A);
numFeat = size(A,2);

labA = renumlab(getlabels(A));

% Obtains the distribution of both classes and generates a classifier with
% normalized output (confidences)
Q = A*qdc*classc;
meanFeat = Q.data.mean;

for clss = 1:size(clsName,1)
    indx1 = (labA == clsName(clss,:));
    A(indx1,:) = A(indx1,:) - ones(clsFreq(clss),1)*meanFeat(clss,:);
end

% 20% of the dataset for training and 80% for Testing
% [Tr, Ts] = gendat(A,0.2);
    
% W = A*qdc*classc;
W = Q;
% Subset Selection
V = 1:numFeat;
SUB_APPROX = 1;
E0 = W.data.cov(:,:,1);
E1 = W.data.cov(:,:,2);
% handlers
[kF, kG] = sfo_fn_klDiv(E0,E1);
kFG = sfo_fn_lincomb({kF, kG},[1,-1]);
[kFs, kGs] = sfo_fn_klDiv(E0,E1,SUB_APPROX);
        
A_kl = sfo_supsub(kG,kF,V,numFeat);
A_kl_greedy = sfo_greedy_k(kFG,V,numFeat);        
A_kl_s = sfo_supsub(kGs,kFs,V,numFeat);

%%
kVec = 1:1:numFeat;
A = heart;

classSel = svc;

% featSel = A*featseli([],'NN',kk);

% fncVal = @(vv) -Tr*featsel(numFeat,vv)*(Tr*featsel(numFeat,vv)*classSel*classc)*testc;

nIt = 100;
errPRT = nan(numFeat,nIt);
errSS = nan(numFeat,nIt);
errGG = nan(numFeat,nIt);
errGS = nan(numFeat,nIt);
errEE = nan(numFeat,nIt);

prwarning(0);

for it = 1:nIt

fprintf('Num of It: %d\n',it)    

[Tr, Ts] = gendat(A,0.2);

    for kk = kVec
    
    
        fprintf('Number of Sensors: %i\n',kk)
        featSel = Tr*featseli([],qdc,0);
        prW = Tr*featSel(:,1:kk)*classSel;
        errPRT(kk, it) = Ts*featSel(:,1:kk)*prW*testc;
    
        % Greedy Heuristics
        fSupSub = featsel(numFeat,A_kl(1:kk));
        ssW = Tr*fSupSub*classSel*classc;
        errSS(kk, it) = Ts*fSupSub*ssW*testc;
    
        fGreedy = featsel(numFeat,A_kl_greedy(1:kk));
        ggW = Tr*fGreedy*classSel*classc;
        errGG(kk, it) = Ts*fGreedy*ggW*testc;
    
        fSurr = featsel(numFeat,A_kl_s(1:kk));
        gsW = Tr*fSurr*classSel*classc;
        errGS(kk, it) = Ts*fSurr*gsW*testc;
    
%     % Exhaustive Search
%     fSelEx = featsel(numFeat,sfo_exhaustive_max(fncVal,V,kk));
%     eeW = Tr*fSelEx*classSel*classc;
%     errEE(kk) = Ts*fSupSub*eeW*testc;

    end

end

%%
figure, hold on,
p1 = plot(kVec, mean(errPRT(kVec,:)*100,2),'-ob','linewidth',1.1);
p2 = plot(kVec, mean(errSS(kVec,:)*100,2),'-xm','linewidth',1.1);
p3 = plot(kVec, mean(errGG(kVec,:)*100,2),'-sk','linewidth',1.1);
p4 = plot(kVec, mean(errGS(kVec,:)*100,2),'--dg','linewidth',1.1);
% p5 = plot(kVec, errEE(kVec),'--dk','linewidth',1.1);
grid on,
set(gca,'fontsize',13)
legend([p1;p2;p3;p4],...
    {'PRTools','SupSub Procedure','KL Greedy','SupSub (Surrogate)'})

xlabel('Number of Features [K]')
ylabel('Classification Error [%]')

%%
figure,hold on,
p1 = errorbar(mean(errPRT(kVec,:)*100,2),std(errPRT(kVec,:)*100,[],2),'-ob','linewidth',1.1);
p2 = errorbar(mean(errSS(kVec,:)*100,2),std(errSS(kVec,:)*100,[],2),'-xm','linewidth',1.1);
p3 = errorbar(mean(errGG(kVec,:)*100,2),std(errGG(kVec,:)*100,[],2),'-sk','linewidth',1.1);
p4 = errorbar(mean(errGS(kVec,:)*100,2),std(errGS(kVec,:)*100,[],2),'--dg','linewidth',1.1);
% p5 = plot(kVec, errEE(kVec),'--dk','linewidth',1.1);
grid on,
set(gca,'fontsize',13)
legend([p1;p2;p3;p4],...
    {'PRTools','SupSub Procedure','KL Greedy','SupSub (Surrogate)'})

xlabel('Number of Features [K]')
ylabel('Classification Error [%]')

