%% Test Submodular Sensor Selection for Detection
% Mario Coutino
% TU Delft 2017
close all,
clear all

% number of sensors
N = 14;
V = 1:N;

% parameters
rho = 0.87;
rho_prev = rho;
iFactor = .96;

% % % generating covariance matrix
% E = zeros(N,N);
% E(1,:) = rho.^(0:N-1);
% for nn = 2:N
%     rho = iFactor*rho;
%     E(nn,nn:end) = rho.^(0:N-nn);
% end
% 
% E = E + E' - diag(ones(N,1));

%
% E = gallery('toeppd',N);
% E = E*E';
%%
% callibrated sensors
E = zeros(N,N);
rho = 0.05;
senRatio = 0.5;
nCalSensor = ceil(N*senRatio);
% rho_vec = [1/(1-rho^2) -rho/(1-rho^2)*ones(1,nCalSensor-1)];
rho_vec = [1/(1-rho^2) -rho/(1-rho^2)*ones(1,nCalSensor-1)];
% alpha = 0.34;
% rho_vec = [1.3 alpha*ones(1,nCalSensor-1)];
%...
 %   zeros(1,N-nCalSensor)];
E(1:nCalSensor,1:nCalSensor) = toeplitz(rho_vec);
E(nCalSensor+1:end,nCalSensor+1:end) = eye(N-nCalSensor,N-nCalSensor); 
rPerm = randperm(N);
% E = E(rPerm,rPerm);
%%
% generating mean vector
theta = ones(N,1);
% theta = flip(0.6.^(0:N-1)');

% snr ratio function
 f_snr = @(A) theta(A)'*inv(E(A,A))*theta(A);
 F_snr = sfo_fn_wrapper(f_snr);
 
 % greedy solution
 tic
 Agrd = sfo_greedy_k(F_snr,V,N);
 grdTime = toc;
 valGrd = kSetFunctionCost(F_snr,Agrd');
  % exhaustive search
%  valExh = nan(N,1);
%  for kk = 1:N
%      Aexh = sfo_exhaustive_max(F_snr,V,kk);
%      valExh(kk) = F_snr(Aexh);
%  end
 %%
 % submodular surrogate implementation #1
% a = min(eig(E))/2;
% S = E - a*eye(N);
% Sinv = S\eye(N);
% f_sub = @(A) subMSE(Sinv,a,theta,A);
% F_sub = sfo_fn_wrapper(f_sub);
% tic
% Asub = sfo_greedy_k(F_sub,V,N); 
% toc
% valSub = kSetFunctionCost(F_snr,Asub');

% submodular surrogate implementation #2 (fast)
tic
Asub_2 = maxSubSNRGreedy(theta,E,N);
subTime = toc;
valSub_2 = kSetFunctionCost(F_snr, Asub_2');

% exhaustive search
 valExh = nan(N,1);
 for kk = 1:N
     Aexh = sfo_exhaustive_max(F_snr,V,kk);
     valExh(kk) = F_snr(Aexh);
 end

 % figures
 figure,
 p2 = plot(V, valExh,'-ob', 'linewidth', 1.1);
 hold on,
 p1 = plot(V,valGrd,'--sg', 'linewidth',1.1);
%  p3 = plot(V,valSub,'--dr', 'linewidth',1.1);
 p4 = plot(V,valSub_2,'--xm', 'linewidth',1.1);
 legend([p1;p2;p4],{'Greedy SNR','Exahustive Search',...
     'Submodular Surrogate'})

% legend([p1;p4],{'Greedy SNR','Submodular Surrogate (fast)'})
% fprintf('Time Greedy: %f\n\n',grdTime)
% fprintf('Time Submodular: %f\n\n',subTime)
 