%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Article:      Submodular Detection for Correlated Measurements
% Section:      Testing Time Greedy vs Convex
% Author:       Mario Coutino
% Affiliation:  TU Delft
% Data:         July 2017
% Conference:   TSP
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fi%%%%%%%%%%%%%%%%
% clear all;
% close all;
% seed rndm
rng(0);

% parameters for simulation
N = 50;
V = 1:N;

nIt = 1e3;

exSNR = nan(N, nIt);
tSNR = nan(N, nIt);
gSNR = nan(N, nIt);
cvxSNR = nan(N, nIt);
worstSNR = nan(N, nIt);

cvxTime = nan(N,nIt);
grdTime = nan(N,nIt);

warning off

for it = 40:100
    try
        if (mod(it,10) == 0)
            fprintf('\n Iteration: %d\n',it)
        end
        
        % CVX Method
        for k = 1:10:N
            fprintf('\n K: %d',k)
            % mean vectors
            theta0 = randn(N,1);
            theta1 = randn(N,1);

            % difference vector
            m = theta1 - theta0;

            % covariance matrix
            E = gallery('toeppd',N);
            E = E/min(eig(E));                  % minimum eig = 1
        
            % true cost function
            f = @(A) getSNR(m(A),E(A,A));
            F = sfo_fn_wrapper(f);
        
            fw = @(A) -f(A);
            Fw = sfo_fn_wrapper(fw);
        
            % covariance decomposition
            tic
            a = 0.5; ainv = a^-1;
            S = E - a*eye(N);
            Sinv = inv(S);
        
            zVec = zeros(N,1);

            cvx_begin sdp quiet
                variable w(N)
                variable t
                minimize t
                subject to
                sum(w) ==  k;
                [Sinv + ainv*diag(w), m;
                    m' , t] >= semidefinite(N+1);
                w(:)<=1;
                w(:)>=0;
            cvx_end
            cvxTime(k,it) = toc;
            
            % greedy for the submodular cost function
            tic
            Ag = maxSubSNRGreedy(m,E,N);
            grdTime(k,it) = toc;
            
        end
        
    catch ME
        rethrow(ME)
        fprintf('\n\n')
    end
        
end
%%
save('testTimeSNRvsK')
close all;
mean_grdTime = nanmean(grdTime(1:10:N,1:100),2);
mean_cvxTime = nanmean(cvxTime(1:10:N,1:100),2);

semilogy(1:10:N,mean_grdTime,'-ob','linewidth',1.1); hold on;
semilogy(1:10:N,mean_cvxTime,'-xr','linewidth',1.1)
% plotting