clear all,
close all,
% number of rows size(H,1)
M = 1e3;

% number of columns size(H,2)
K = 10;

% H matrix
H = randn(M,K);

% Covariance matrix for x (Sigma)
Ar = rand(K);
Sigma = 10*(Ar*Ar' + eye(K));
% rho = 0.34;
% Sigma = (1-rho)*eye(K) + rho*ones(K);

% Noise Cov matrix (R)
Ar = rand(M);
R = 10*(Ar*Ar' + eye(M));
% rho = 0.78;
% R = (1-rho)*eye(M) + rho*ones(M);

% number of selected rows nnz(Phi)
st = 1;
Mmax = 1e2;
% VV = 1:st:Mmax;

SigmaInv = inv(Sigma);

eigH = sort(eig(H*H'));
eigR = sort(eig(R));
%%
VV = 1:1:100;
% VV = K+1;
isVerbose = 1;
for S = VV
    dK = S - K + 2;
    % Selection Matrix Phi
    ind = randperm(M,S);
    Phi = eye(M);
    Phi = Phi(ind,:);

    T = SigmaInv + H'*Phi'*(Phi*R*Phi')^-1*Phi*H;
    B = H'*Phi'*(Phi*R*Phi')^-1*Phi*H;
    
    UbndN = norm(SigmaInv,'fro') + norm(H,2)*eigR(1)^-1*norm(H,'fro');
    Fnorm = norm(T,'fro');
    LbndN = norm(SigmaInv,'fro'); 
    
    UbndT = trace(SigmaInv) + eigH(end-S+1:end)'*eigR(1:S).^-1;
    TTrace = trace(T);
    LbndT = trace(SigmaInv);
    
    UbndEig = norm(SigmaInv,2) + eigH(end)*eig(1)^-1;
    TEig = max(eig(T));
    LbndEig = norm(SigmaInv,2);
    
    Ta = (UbndN^2*UbndEig - LbndEig^2*LbndT)^-1 * ...
        [LbndEig -UbndT;...
        -UbndN^2 LbndN^2];
%     fprintf('-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n\n')
    bnTi(S) = [LbndT K]*Ta*[K; 1];
    bnTi2(S) = K^2/UbndT;
    
    TiTrace(S) = trace(inv(T));
    
    if(isVerbose)
        fprintf('-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n\n');
        fprintf('Frobenius Norm: ')
        fprintf('%f >= %f >= %f\n\n', UbndN, Fnorm, LbndN);
        fprintf('-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n\n');
        fprintf('Trace: ')
        fprintf('%f >= %f >= %f\n\n', UbndT, TTrace, LbndT);
        fprintf('-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n\n');
        fprintf('Max Eigenvalue: ')
        fprintf('%f >= %f >= %f\n\n', UbndEig, TEig, LbndEig);
        fprintf('-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n\n');
    end
end

plot(bnTi,'b'), hold on,
plot(bnTi2,'k'),
plot(TiTrace,'g')
set(gca,'yscale','log')
%%
    
    %     UbndN = norm(SigmaInv,'fro') + sum(eigR(1:1+S).^-2);
%     LbndN = max(norm(SigmaInv,'fro'), sum(eigR(end-K+1:end).^-2))