
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 
% Goal: Convergence properties of AM procedure of dictionary learning algorithm
%
% Author: Geethu Joseph, ECE Dept., IISc Banglore, India
% Email : geethu@iisc.ac.in
% Date  : 10 Feb. 2017
% 
% This script/program is released under the Commons Creative Licence
% with Attribution Non-commercial Share Alike (by-nc-sa)
% http://creativecommons.org/licenses/by-nc-sa/3.0/
% Short Disclaimer: this script is for educational purpose only.%
%
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;  
home;

FOLDER = 'Temp_Plots';
OUTFILE = fullfile(FOLDER, 'Convergence_DLSBL.mat');

CHANGE_FIG    = fullfile(FOLDER, 'Convergence_Adjacent_DLSBL.fig');
ERROR_FIG     = fullfile(FOLDER, 'Convergence_Error_DLSBL.fig');
CHANGE_EPS    = fullfile(FOLDER, 'Convergence_Adjacent_DLSBL.eps');
ERROR_EPS     = fullfile(FOLDER, 'Convergence_Error_DLSBL.eps');

%% Control Parameters

%ITER_NUM    = 25;        % Trial number (i.e. number of repeating the experiment)
MES_LEN     = 30;       % Row number of the dictionary matrix 
SPARSE_LEN  = 60;       % Column number of the dictionary matrix
SPARSITY    = 6;        % Number of nonzero rows (i.e. source number) in the solution matrix

PRINT       = 1;
SPARSE_NUM  = 1000;    % Number of measurement vectors
SNR         = 20;
MAX_ITER    = 100;
%% Iterations

fprintf('\n Convergence \n');

fprintf('\n************************PARAMETERS************************\n');
fprintf(...
    ' Measurements \t = %d \n Lt of unknown \t = %d \n Sparsity \t = %d \n '...
    , MES_LEN , SPARSE_LEN, SPARSITY );


coeff_err_tot = 0;
coeff_change_tot = 0;
fit_coeff_err_tot = zeros(1,2);
fit_coeff_change_tot = zeros(1,2);

for iter = 1 : MAX_ITER
    iter
% 	Generate dictionary matrix with columns draw uniformly from the surface of a unit hypersphere
	A = randn(MES_LEN, SPARSE_LEN);
    A = A./(ones(MES_LEN,1)*sqrt(sum(A.^2)));
    A = A./(ones(MES_LEN,1)*sign(A(1,:)));
    A = sortrows(A',1)';

    Xgen = zeros(SPARSE_LEN, SPARSE_NUM);
    % Generate the K nonzero rows     
	for i = 1 : SPARSE_NUM
        ind = randperm(SPARSE_LEN);
        indice = ind(1:SPARSITY);
        nonzeroX = randn(SPARSITY,1);
        Xgen(indice,i) = nonzeroX;
	end
   
    % Noiseless signal
    Y_Noiseless = A * Xgen;
    
	% Observation noise
    if SNR == Inf
        Y = Y_Noiseless;
        stdnoise = 0;
    else
        stdnoise = std(reshape(Y_Noiseless,MES_LEN*SPARSE_NUM,1))*10^(-SNR/20);
        noise = randn(MES_LEN, SPARSE_NUM) * stdnoise;

	% Noisy signal
        Y = Y_Noiseless + noise;
	end;
    
  
%% ****************** Bayesian Dictionary Learning ****************** 
    [dummy dummy error change] = DLSBL_Err(Y, stdnoise*eye(MES_LEN),SPARSE_LEN);
    error = error';
  
    xAxis_err = 1:length(error);
    range = 1:length(error)-25;
    coeff_err = max(xAxis_err.*error);
    coeff_err_tot = coeff_err_tot + coeff_err;
    
    error_fit = log(error(range));
    fit_coeff_err = polyfit(1:length(error_fit),error_fit,1);
    fit_coeff_err_tot = fit_coeff_err_tot + fit_coeff_err;
    
    xAxis_change = 1:length(change);
    coeff_change = max(xAxis_change.*(xAxis_change-1).*change./(2*xAxis_change-1));
    coeff_change_tot = coeff_change_tot + coeff_change;

    range = 1:length(change)-25;
    change_fit = log(change(range));
    fit_coeff_change = polyfit(range,change_fit,1);
    fit_coeff_change_tot = fit_coeff_change_tot + fit_coeff_change;
    
end;

coeff_err_tot = coeff_err_tot/MAX_ITER;
coeff_change_tot = coeff_change_tot/MAX_ITER;
fit_coeff_err_tot = fit_coeff_err_tot/MAX_ITER;
fit_coeff_change_tot = fit_coeff_change_tot/MAX_ITER;

  save(OUTFILE, 'MES_LEN', 'SPARSE_LEN','SPARSITY', 'SNR', 'SPARSE_NUM', 'error', 'change',...
      'coeff_err_tot','fit_coeff_err_tot','coeff_change_tot','fit_coeff_change_tot');

  
%% Plot and save figure

% colors
DarkGreen   = [0.2       0.5000    0.2   ];
LightGreen  = [0.4660    0.6740    0.1880];
LightBlue   = [0         0.8       1     ];
SkyBlue     = [0         0.4470    0.7410];
Purple      = [0.4940    0.1840    0.5560];
DarkYellow  = [0.9290    0.6940    0.1250];
Orange      = [0.8500    0.3250    0.0980];
BrickRed    = [0.6350    0.0780    0.1840];
DarkCyan    = [0         0.6       0.6   ];
Gray        = [0.55      0.55      0.55  ];

%%%%%%% change
figure;
set(0,'defaulttextinterpreter','tex')
set(0,'DefaultLineLineWidth',3)
set(0,'DefaultAxesFontSize',16)
set(0,'DefaultLineMarkerSize',14)
set(0,'DefaultAxesFontWeight','bold')
set(gca,'FontSize',16)
set(get(gca,'Xlabel'),'FontSize',16)
set(get(gca,'Ylabel'),'FontSize',16)
set(get(gca,'Title'),'FontSize',16)
set(get(gca,'Xlabel'),'FontWeight','bold')
set(get(gca,'Ylabel'),'FontWeight','bold')
set(get(gca,'Title'),'FontWeight','bold')


fit_curve_change = exp(fit_coeff_change(1)*xAxis_change+fit_coeff_change(2));

HA = semilogy(  xAxis_change, change,'-',...
                xAxis_change, coeff_change.*(2*xAxis_change-1)./(xAxis_change.*(xAxis_change-1)) ,'.',...
                xAxis_change, fit_curve_change,'--'...
                );
set(HA(1),'color', Orange);         
set(HA(3),'color', SkyBlue);
set(HA(2),'color', DarkGreen);

axis square;
ylabel('$\Vert \mathbf{A}^{(r,u-1)} - \mathbf{A}^{(r,u)} \Vert$','Interpreter','LaTex');
xlabel('Iterate index u');
legend('Simulation','Bound in (27): C(2u-1)/u(u-1)','Fit Curve: exp(au+b)');
%legend boxoff

% Save figures
saveas(gca, CHANGE_FIG);
saveas(gca, CHANGE_EPS, 'epsc');

%%%%%%% Error
figure;
fit_curve_err = exp(fit_coeff_err(1)*xAxis_err+fit_coeff_err(2));

HA = semilogy(  xAxis_err, error ,'-',...
                xAxis_err, coeff_err./xAxis_err ,'.',...
                xAxis_err, fit_curve_err,'--'...
                );
            
set(HA(1),'color', Orange);         
set(HA(3),'color', SkyBlue);
set(HA(2),'color', DarkGreen);

axis square;
ylabel('$\Vert \mathbf{A}^{(r,u)} - \mathbf{A}^{(r)} \Vert$','Interpreter','LaTex');
xlabel('Iterate index u');

legend('Simulation','Bound in Theorem 2: C/u','Fit Curve: exp(au+b)');
%legend boxoff;
% Save figures
saveas(gca, ERROR_FIG);
saveas(gca, ERROR_EPS, 'epsc');
