%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This program computes the optimal policy for a multihop fast fading EH
% link by solving an overall GP . 
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all 
close all 
NumPkt 	 	    = 	1e7;                                        % no of packets
rho1 			= 	0.05:0.05:1;                                     % probability of energy harvesting at transmitter
rho2            =   0.3;
rho3            =   0.3;
Es_db			=   3;   % 8 dB corresponds to 200 microJoule  Energy harvested per slot 
Es 			    =   10^(Es_db/10);                                  % Energy harvested per slot
B1              =   200*Es;                                                     % battery capacity
B2              =   200*Es;
B3              =   100*Es;
K 			    = 	4;                                                         % Max no of slots
Tp              =   1;                                                        % Packet Duration
R               =   1;
Lmax            =   10*Es; 
epsilon         =   1e-5;
el_max          =   100;
K1              =   K;
K2              =   K;
R2              =   R*Es;
R3              =   R*Es;
os1            = 0.005;                               % change the variables os1 and os2 to control the size of the battery
os2            = 0.005;

for rhot = rho1                                        % Loop is running for all  rho values
       
        rhoidt 		= 	find(rhot == rho1)
       
        hprocess1 	= 	(rand(1,NumPkt*(K1+K2)) <= rhot)*Es;
    for rhor = rho2  
        
        rhoidr 		= 	find(rhor == rho2);
        hprocess2 	= 	(rand(1,NumPkt*(K1+K2)) <= rhor)*Es;
        hprocess3 	= 	(rand(1,NumPkt*(K1+K2)) <= rho3)*Es;
        BT1         = 	50*Es;  BT2  =   50*Es; BT3 = 50*Es; BTR1= 50*Es; BTR2 = 50*Es; BTR3 =50*Es; 
        
       % [Lvec, LvR]        = opt_policy_Geo_global(rhot, rhor, rho3, Lmax, Es, K1,K2,R2, R3,el_max,epsilon, os1, os2)
        %[Lvec, LvR]        = opt_policy_Geo_global_test(rhot, rhor, rho3, Lmax, Es, K1,K2,R2, R3,el_max,epsilon);
%         Lvec_rel    = opt_policy_Geo_global_rel(rhot, rhor, rho3, Lmax, K1,K2,Es,R2, R3,el_max,epsilon);
    
 Lvec1 =  [Lmax Lmax Lmax Lmax]; 
 Lvec2 =  [Lmax Lmax Lmax Lmax];
 
        NumAck(rhoidt,rhoidr)	= 	0;
        NumAck1(rhoidt,rhoidr)  =   0;
       % NumAckR(rhoidt,rhoidr)	= 	0;
        ell(rhoidt)=0;
 for pac= 1:NumPkt
     ACK1 	= 	0; ACK2=0;  ACKR1=0; ACKR2=0;
     
     i=0; ir=0;
     for kk = 0:K1-1                                              % Loop is running for a frame
		BT1  =   min(BT1+hprocess1((pac-1)*(K1+K2)+kk+1),B1);
        BT2  =   min(BT2+hprocess2((pac-1)*(K1+K2)+kk+1),B2);
        BT3  =   min(BT3+hprocess3((pac-1)*(K1+K2)+kk+1),B3);
%         BTR1 =   min(BTR1+hprocess1((pac-1)*(K1+K2)+kk+1),B1);
%         BTR2 =   min(BTR2+hprocess2((pac-1)*(K1+K2)+kk+1),B2);
%         BTR3 =   min(BTR3+hprocess3((pac-1)*(K1+K2)+kk+1),B3);
        gamma 	= 	exprnd(1);
			if ((BT1 >=Lvec1(i+1)) && (ACK1 == 0) &&(BT2>=R2) )
				BT1 	= 	BT1 - Lvec1(i+1);
                BT2     =   BT2-R2;                
                %sk=sk+(Lvec(i+1)*gamma);
                Pe = exp(-(gamma*Lvec1(i+1)/Tp));
                ACK1 = (Pe<=rand(1,1));
                i=i+1;
                %ell=ell+1;
				%ACK 	= 	(rand(1,1) >= Pe);
            end
            end
     i=0; ir=0;
    for kk=0:K2-1
        BT1  =   min(BT1+hprocess1((pac-1)*(K1+K2)+K1+kk+1),B1);
        BT2  =   min(BT2+hprocess2((pac-1)*(K1+K2)+K1+kk+1),B2);
        BT3  =   min(BT3+hprocess3((pac-1)*(K1+K2)+K1+kk+1),B3);
%         BTR1 =   min(BTR1+hprocess1((pac-1)*(K1+K2)+K1+kk+1),B1);
%         BTR2 =   min(BTR2+hprocess2((pac-1)*(K1+K2)+K1+kk+1),B2);
%         BTR3 =   min(BTR3+hprocess3((pac-1)*(K1+K2)+K1+kk+1),B3);
        gamma 	= 	exprnd(1);
            if ((BT2 >=Lvec2(i+1)) && (ACK1 == 1) && (ACK2==0) &&(BT3>=R3) )
				BT2 	= 	BT2 - Lvec2(i+1);
                BT3     =   BT3-R3;                
                %sk=sk+(Lvec(i+1)*gamma);
                Pe = exp(-(gamma*Lvec2(i+1)/Tp));
                ACK2 = (Pe<=rand(1,1));
                i=i+1;
				%ACK 	= 	(rand(1,1) >= Pe);
            end
            
    end
    
       NumAck(rhoidt,rhoidr)	= 	NumAck(rhoidt,rhoidr) + ACK2;
       NumAck1(rhoidt,rhoidr)	= 	NumAck1(rhoidt,rhoidr) + ACK1;
       
 
 end
 %NumAck
 % ell
 
    end
end
Out = ones(length(rho1),length(rho2)) -NumAck/NumPkt;    % calculating the outage probability prob of success =  total no of ACK / Total no of packets.
Out2= ones(length(rho1),length(rho2))- NumAck./NumAck1;

fname = ['mat/Multihop_EPP_global_optimal__pmax_',num2str(Lmax),'_R2_',num2str(R2),'_R3_',num2str(R3),'_Es_',num2str(Es_db),'_K1_',num2str(K1),'_K2_',num2str(K2),'quantz',datestr(now,'mmmm_dd_yy_HH_MM_SS'),'.mat'];
eval(['save ', fname,' rho2 rho3 Out Out2']);