%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [ a,b,c,d ] = coeff_ARQ_ff_slotalloc( z,i,j,CC1,CC2,CC3,R3)
% This function calculates the coefficients to solve for 
% the optimal power allocation using GP 
% for ARQ FAST FADING channel
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ a,b,c,d ] = coeff_ARQ_ff_slotalloc( z,i,j,CC1,CC2,CC3,R3)
%This function calculates the coefficients to solve for optimal power allocation using GP 
%for ARQ FAST FADING channel


if ((i==5)&&(j==1))
    z11=z(1);  z14=z(4);
    z12=z(2);  z15=z(5);
    z13=z(3);  z21=z(6);
     
    DEN1 = 1+((z15^(-1))*(z21^(-1)));
    DEN2 = CC2+1+(((z15)^(-1))*z21);
    DEN3=  CC3+R3*(z15^(-1));
    DEN4 = CC1+1+(z11^(-1))+(z12^(-1))+(z13^(-1))+(z14^(-1));
            a1 =1/DEN1;
            a2=((z15^(-1))*(z21^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+1)/DEN2;
            b2 = (((z15)^(-1))*z21)/DEN2;
    b=[b1 b2];
            c1 = CC3/DEN3;
            c2= (R3*(z15^(-1)))/DEN3;
    c=[c1 c2];
            d1 = (CC1+1)/DEN4;
            d2 = (z11^(-1))/DEN4;
            d3 = (z12^(-1))/DEN4;
            d4 = (z13^(-1))/DEN4;
            d5 = (z14^(-1))/DEN4;
    d=[d1 d2 d3 d4 d5];
    
elseif ((i==4)&&(j==2)) %%%%%%%%%%%%%%%%%%%%% CASE II %%%%%%%% CASE II %%%%%%%%%%%
    z11=z(1);  z14=z(4);
    z12=z(2);  z21=z(5);
    z13=z(3);  z22=z(6);
    DEN1 = 1+((z14^(-1))*(z22^(-1))); 
    DEN2 = CC2+1+(z21^(-1))+((z14)^(-1))*(z21+z22*(z21^(-2)));
    DEN3=  (CC3/R3)+(z14^(-1))*(1+z21^(-1));
    DEN4 = CC1+1+z11^(-1)+z12^(-1)+z13^(-1);
            a1 =1/DEN1;
            a2=((z14^(-1))*(z22^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+1)/DEN2;
            b2 = (z21^(-1))/DEN2;
            b3 = (((z14)^(-1))*z21)/DEN2;
            b4 = ((z14)^(-1))*(z22*(z21^(-2)))/DEN2;
    b=[b1 b2 b3 b4];
            c1 = CC3/(R3*DEN3);
            c2 = (z14^(-1))/DEN3;
            c3 = ((z14^(-1))*(z21^(-1)))/DEN3;
    c=[c1 c2 c3];
            d1 = (CC1+1)/DEN4;
            d2 = (z11^(-1))/DEN4;
            d3 = (z12^(-1))/DEN4;
            d4 = (z13^(-1))/DEN4;
    d=[d1 d2 d3 d4];
    
    
    elseif ((i==3)&&(j==3)) %%%%%%%%%%%%%%%%%%%%%%%%%%%% CASE III %%%% CASE III
    z12=z(1);  z22=z(4);
    z13=z(2);  z23=z(5);
    z14=z(3);  z24=z(6);
    DEN1 = 1+((z14^(-1))*(z24^(-1))); 
    DEN2 = CC2+1+(z22^(-1))+(z23^(-1))+((z14)^(-1))*(z22+z23*z22^(-2)+z24*(z23^(-2)));
    DEN3=  (CC3/R3)+(z14^(-1))*(1+(z22^(-1))+(z23^(-1)));
    DEN4 = CC1+1+z12^(-1)+z13^(-1);
            a1 =1/DEN1;
            a2=((z14^(-1))*(z24^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+1)/DEN2;
            b2 = (z22^(-1))/DEN2;
            b3 = (z23^(-1))/DEN2;
            b4 = (((z14)^(-1))*z22)/DEN2;
            b5 = ((z14)^(-1))*(z23*(z22^(-2)))/DEN2;
            b6 = ((z14)^(-1))*(z24*(z23^(-2)))/DEN2;
                       
    b=[b1 b2 b3 b4 b5 b6];
            c1 = CC3/(R3*DEN3);
            c2 = (z14^(-1))/DEN3;
            c3 = ((z14^(-1))*(z22^(-1)))/DEN3;
            c4 = ((z14^(-1))*(z23^(-1)))/DEN3;
    c=[c1 c2 c3 c4];
            d1 = (CC1+1)/DEN4;
            d2 = (z12^(-1))/DEN4;
            d3 = (z13^(-1))/DEN4;
    d=[d1 d2 d3];
    elseif ((i==2)&&(j==4))  %%%%%%%%%%%%%%%%%%%%%%%%%%%% CASE IV %%%% CASE IV %%%%%%%%%%%%%%%%%%%55
    z13=z(1);  z22=z(4);
    z14=z(2);  z23=z(5);
    z21=z(3);  z24=z(6);
    DEN1 = 1+((z14^(-1))*(z24^(-1))); 
    DEN2 = CC2+1+((z21)^(-1))+((z22)^(-1))+((z23)^(-1))+((z14)^(-1))*(z21+z22*((z21)^(-2))+z23*((z22)^(-2))+z24*((z23)^(-2)));
    DEN3=  (CC3/R3)+(z14^(-1))*(1+(z21^(-1))+(z22^(-1))+(z23^(-1)));
    DEN4 = (CC1+1+z13^(-1));
    
            a1 =1/DEN1;
            a2=((z14^(-1))*(z24^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+1)/DEN2;
            b2 = ((z21)^(-1))/DEN2;
            b3 = ((z22)^(-1))/DEN2;
            b4 = ((z23)^(-1))/DEN2;
            b5 = (((z14)^(-1))*z21)/DEN2;
            b6 = (((z14)^(-1))*z22*((z21)^(-2)))/DEN2;
            b7 = (((z14)^(-1))*z23*((z22)^(-2)))/DEN2;
            b8 = (((z14)^(-1))*z24*((z23)^(-2)))/DEN2;
            
    b=[b1 b2 b3 b4 b5 b6 b7 b8];
            c1 = CC3/(R3*DEN3);
            c2 = ((z14^(-1)))/DEN3;
            c3 = ((z14^(-1))*((z21)^(-1)))/DEN3;
            c4 = ((z14^(-1))*((z22)^(-1)))/DEN3;
            c5 = ((z14^(-1))*((z23)^(-1)))/DEN3;
    c=[c1 c2 c3 c4 c5];
             d1 = (CC1+1)/DEN4;
             d2 = (z13^(-1))/DEN4;
     d=[d1 d2];
    
   elseif ((i==1)&&(j==5))  %%%%%%%%%%%%%%%%%%%%%%% CASE V  %%%%%%%%% CASE V
    z14=z(1);  z23=z(4);
    z21=z(2);  z24=z(5);
    z22=z(3);  z25=z(6);
    DEN1 = 1+((z14^(-1))*(z25^(-1))); 
    DEN2 = CC2+1+((z21)^(-1))+((z22)^(-1))+((z23)^(-1))+((z24)^(-1))+((z14)^(-1))*(z21+z22*((z21)^(-2))+z23*((z22)^(-2))+z24*((z23)^(-2))+z25*((z24)^(-2)));
    DEN3 =  (CC3/R3)+(z14^(-1))*(1+z21^(-1)+z22^(-1)+z23^(-1)+z24^(-1));
    
            a1 =1/DEN1;
            a2=((z14^(-1))*(z25^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+1)/DEN2;
            b2 = ((z21)^(-1))/DEN2;
            b3 = ((z22)^(-1))/DEN2;
            b4 = ((z23)^(-1))/DEN2;
            b5 = (((z14)^(-1))*z21)/DEN2;
            b6 = (((z14)^(-1))*z22*((z21)^(-2)))/DEN2;
            b7 = (((z14)^(-1))*z23*((z22)^(-2)))/DEN2;
            b8 = (((z14)^(-1))*z24*((z23)^(-2)))/DEN2;
            b9 = ((z24)^(-1))/DEN2;
            b10 =(((z14)^(-1))*z25*((z24)^(-2)))/DEN2;
            
    b=[b1 b2 b3 b4 b5 b6 b7 b8 b9 b10];
            c1 = CC3/(R3*DEN3);
            c2 = (z14^(-1))/DEN3;
            c3 = (z14^(-1))*(z21^(-1))/DEN3;
            c4 = (z14^(-1))*(z22^(-1))/DEN3;
            c5 = (z14^(-1))*(z23^(-1))/DEN3;
            c6 = (z14^(-1))*(z24^(-1))/DEN3;
    c=[c1 c2 c3 c4 c5 c6];
       d=0; 
    
    end


end

