%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [ E, ER ] = opt_policy_Geo_global( rhot, rhor, rho3, Lmax, Es, 
% K1,K2,R2,R3,el_max,epsilon, os1,os2)
% This function finds the optimal policy by exhaustively 
% searching over all possible integer combinations nodes. 
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [ E, ER ] = opt_policy_Geo_global( rhot, rhor, rho3, Lmax, Es, K1,K2,R2,R3,el_max,epsilon, os1,os2)
%This function find the opt-policy by exhaustively searching the policy over all possible integer combinations nodes. 

cn=1e-10;
obj=1e-30;
CC1=(K1+K2)*rhot*Es-os1;
CC2=(K1+K2)*rhor*Es-os2;
CC3= (K1+K2)*rho3*Es;
for i=1:K1
    
for j=1:K2
        if((i==1)&&(j==1))
         
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= cn; E14=2; t=0.5;
                E21=cn; E22=cn; E23= cn; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while ((epsilon<=(norm(E_diff,2)))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1); a2=a(2);   
                     b1=b(1); b2=b(2);  
                     c1=c(1); c2=c(2);
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13==1+cn;
                                     z21==1+cn; z22==1+cn; z23==1+cn;
                                     z14<=Lmax+1; z24<=Lmax+1;
                                     z14>=1+cn;     z24>=1+cn;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z14 <= CC1+1;
                                          R2+ ((z14)^(-1))+z24 <= (((CC2+1)/b1)^b1)*((((z14)^(-1))*z24)/b2)^b2;
                                          R3 <= ((CC3/c1)^c1)*((R3*((z14)^(-1))/c2)^c2); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old; 
                 end
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASEI ENDS %%%% CASE I ENDS%%%%%%%%%%%     
                 
       elseif ((i==1)&&(j==2))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= cn; E14=2; t=0.5;
                E21=cn; E22=cn; E23= 0.5; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while ((epsilon<=(norm(E_diff,2)))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1); a2=a(2);    
                     b1=b(1); b2=b(2);   b3=b(3); b4=b(4);
                     c1=c(1);  c2=c(2);  c3=c(3); 
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13==1+cn; z14>=1+cn; z14<=Lmax+1;
                                     z21==1+cn; z22==1+cn; z23>=1+cn; z23<=Lmax+1;                                       
                                     z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z14 <= CC1+1;
                                          R2+((z14)^(-1))+z23+(z23^(-2))*z24+((z23^(-1))*(z14^(-1))) <= (((CC2+1)/b1)^b1)*(((z23^(-1))/b2)^b2)*(((((z14)^(-1))*z23)/b3)^b3)*(((((z14)^(-1))*z24*(z23^(-2)))/b4)^b4);
                                          1+z23^(-1) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*((((z14)^(-1))*(z23^(-1))/c3)^c3); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE II ENDS %%%% CASE II ENDS%%%%%%%%%%%     
                     elseif ((i==1)&&(j==3))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= cn; E14=2; t=0.5;
                E21=cn; E22=0.5; E23= 1.5; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while ((epsilon<=(norm(E_diff,2)))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c, d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1, CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1); a2=a(2);   
                     b1=b(1); b2=b(2);  b3=b(3); b4=b(4); b5 =b(5); b6=b(6); 
                     c1=c(1); c2=c(2);  c3=c(3); c4=c(4);
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13==1+cn;
                                     z21==1+cn; z22>=1+cn; z22<=Lmax+1;
                                     z14<=Lmax+1; z14>=1+cn; 
                                      z23>=z22; z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z14 <= CC1+1;
                                          R2+((z14)^(-1))*(1+(z22^(-1))+(z23^(-1)))+z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*(((z22^(-1))/b2)^b2)*(((z23^(-1))/b3)^b3)*(((((z14)^(-1))*z22)/b4)^b4)*(((((z14)^(-1))*z23*((z22)^(-2)))/b5)^b5)*(((((z14)^(-1))*z24*((z23)^(-2)))/b6)^b6);
                                          1+z22^(-1)+z23^(-1) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*((((z14)^(-1))*(z22^(-1))/c3)^c3)*((((z14)^(-1))*(z23^(-1))/c4)^c4); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE III ENDS %%%% CASE III ENDS%%%%%%%%%%%
            elseif ((i==1)&&(j==4))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= cn; E14=2; t=0.5;
                E21=0.5; E22=1; E23= 1.5; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while ((epsilon<=(norm(E_diff,2)))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c, d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1); a2=a(2);   
                     b1=b(1); b2=b(2);  b3=b(3); b4=b(4); b5=b(5); b6=b(6); b7=b(7); b8=b(8);  
                     c1=c(1); c2=c(2);  c3=c(3); c4=c(4); c5=c(5);
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13==1+cn;
                                     z21>=1+cn; z21<=Lmax+1;
                                     z14<=Lmax+1; z14>=1+cn; 
                                      z22>=z21; z22*(z21^(-1))<= 1+Lmax; z23>=z22; z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z14 <= CC1+1;
                                          R2+((z14)^(-1))*(1+((z21)^(-1))+((z22)^(-1))+((z23)^(-1)))+z21+ ((z21)^(-2))*z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*((((z21)^(-1))/b2)^b2)*((((z22)^(-1))/b3)^b3)*((((z23)^(-1))/b4)^b4)*(((((z14)^(-1))*z21)/b5)^b5)*(((((z14)^(-1))*z22*((z21)^(-2)))/b6)^b6)*(((((z14)^(-1))*z23*((z22)^(-2)))/b7)^b7)*(((((z14)^(-1))*z24*((z23)^(-2)))/b8)^b8);
                                          1+z21^(-1)+z22^(-1)+z23^(-1) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*((((z14)^(-1))*(z21^(-1))/c3)^c3)*((((z14)^(-1))*(z22^(-1))/c4)^c4)*((((z14)^(-1))*(z23^(-1))/c5)^c5); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE IV ENDS %%%% CASE IV ENDS%%%%%%%%%%%      
            elseif ((i==2)&&(j==1))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= 0.5; E14=0.5; t=0.5;
                E21=cn; E22=cn; E23= cn; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  
                     c1=c(1);  c2=c(2);        
                     d1 =d(1); d2=d(2);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13>=1+cn; z13<=Lmax+1; 
                                     z21==1+cn; z22==1+cn; z23==1+cn; z24>=z23+cn; z24<=Lmax+1;
                                     z14>=z13; z14*(z13^(-1))<= 1+Lmax;
                                       
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z13+(z14*(z13^(-2))) <= (((CC1+1)/d1)^d1)*(((z13^(-1))/d2)^d2); 
                                          R2*(1+z13^(-1))+ ((z14)^(-1))+z24 <= (((CC2+1)/b1)^b1)*((((z14)^(-1))*z24)/b2)^b2;
                                          R3 <= ((CC3/c1)^c1)*((R3*((z14)^(-1))/c2)^c2); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE V ENDS %%%% CASE V ENDS%%%%%%%%%%%  
            elseif ((i==2)&&(j==2))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= 0.75; E14=1.5; t=0.5;
                E21=cn; E22=cn; E23= 1; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);   b3=b(3); b4 =b(4);
                     c1=c(1);  c2=c(2);   c3=c(3);  
                     d1 =d(1); d2=d(2);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13>=1+cn; z13<=Lmax+1; 
                                     z21==1+cn; z22==1+cn; z23>=1+cn; z23<=Lmax+1;                                       
                                     z14>=z13; z14*(z13^(-1))<= 1+Lmax; 
                                     z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                      
                                      
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*((((z14^(-1))*(z24^(-1)))/a2)^a2);
                                          z13+(z14*(z13^(-2))) <= (((CC1+1)/d1)^d1)*((((z13)^(-1))/d2)^d2);
                                          R2*(1+z13^(-1))+ ((z14)^(-1))+z23+(z23^(-2))*z24+((z23^(-1))*(z14^(-1))) <= (((CC2+1)/b1)^b1)*(((z23^(-1))/b2)^b2)*(((((z14)^(-1))*z23)/b3)^b3)*(((((z14)^(-1))*z24*(z23^(-2)))/b4)^b4);
                                          (1+z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z23)^(-1)))/c3)^c3); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE VI ENDS %%%% CASE VI ENDS%%%%%%%%%%%   
            elseif ((i==2)&&(j==3))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= 0.5; E14=1; t=0.5;
                E21=cn; E22=0.5; E23= 1; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  b3=b(3); b4=b(4); b5 =b(5); b6=b(6);
                     c1=c(1);  c2=c(2);  c3=c(3); c4=c(4); 
                     d1 =d(1); d2=d(2);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13>=1+cn; z13<=Lmax+1; 
                                     z21==1+cn; z22>=1+cn;  z22<=Lmax+1;
                                     z14>=z13; z14*(z13^(-1))<= 1+Lmax; 
                                     z23>=z22; z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z13+(z14*(z13^(-2))) <= (((CC1+1)/d1)^d1)*((((z13)^(-1))/d2)^d2);
                                          R2*(1+z13^(-1))+ ((z14)^(-1))*(1+(z22^(-1))+(z23^(-1)))+z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*(((z22^(-1))/b2)^b2)*(((z23^(-1))/b3)^b3)*(((((z14)^(-1))*z22)/b4)^b4)*(((((z14)^(-1))*z23*((z22)^(-2)))/b5)^b5)*(((((z14)^(-1))*z24*((z23)^(-2)))/b6)^b6);
                                          (1+z22^(-1)+z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z22)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z23)^(-1)))/c4)^c4); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE VII ENDS %%%% CASE VII ENDS%%%%%%%%%%%  
                elseif ((i==2)&&(j==4))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=cn; E13= 0.5; E14=1; t=0.5;
                E21= 0.25; E22=0.5; E23= 1; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                   [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  b3=b(3); b4=b(4); b5=b(5); b6=b(6); b7=b(7); b8=b(8);
                     c1=c(1);  c2=c(2);  c3=c(3); c4=c(4); c5=c(5); 
                     d1 =d(1); d2=d(2);
                     
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12==1+cn; z13>=1+cn; z13<=Lmax+1; 
                                     z21>=1+cn; z21<=Lmax+1;
                                     z14>=z13; z14*(z13^(-1))<= 1+Lmax;
                                     z22>=z21; z22*(z21^(-1))<= 1+Lmax; z23>=z22; z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*((((z14^(-1))*(z24^(-1)))/a2)^a2);
                                          z13+(z14*(z13^(-2))) <= (((CC1+1)/d1)^d1)*((((z13)^(-1))/d2)^d2);
                                          R2*(1+z13^(-1))+ ((z14)^(-1))*(1+((z21)^(-1))+((z22)^(-1))+((z23)^(-1)))+z21+ ((z21)^(-2))*z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*((((z21)^(-1))/b2)^b2)*((((z22)^(-1))/b3)^b3)*((((z23)^(-1))/b4)^b4)*(((((z14)^(-1))*z21)/b5)^b5)*(((((z14)^(-1))*z22*((z21)^(-2)))/b6)^b6)*(((((z14)^(-1))*z23*((z22)^(-2)))/b7)^b7)*(((((z14)^(-1))*z24*((z23)^(-2)))/b8)^b8);
                                          (1+z21^(-1)+z22^(-1)+z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z21)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z22)^(-1)))/c4)^c4)*(((((z14)^(-1))*((z23)^(-1)))/c5)^c5); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE VIII ENDS %%%% CASE VIII ENDS%%%%%%%%%%%  
    elseif ((i==3)&&(j==1))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=0.5; E13= 1; E14=2; t=0.5;
                E21=cn; E22=cn; E23=cn; E24=0.5;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                 [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  
                     c1=c(1);  c2=c(2); 
                     d1 =d(1); d2=d(2); d3=d(3);
                      
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12>=1+cn; z12<=Lmax+1; 
                                     z21==1+cn; z22==1+cn; z23==1+cn; z24>=1+cn; z24<=Lmax+1;
                                     z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax;                                        
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z12+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z12^(-1))/d2)^d2)*((z13^(-1))/d3)^d3;
                                          R2*(1+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))+z24 <= (((CC2+1)/b1)^b1)*((((z14)^(-1))*z24)/b2)^b2;
                                          R3 <= ((CC3/c1)^c1)*((R3*((z14)^(-1))/c2)^c2); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE IX ENDS %%%% CASE IX ENDS%%%%%%%%%%%  
            elseif ((i==3)&&(j==2))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=0.5; E13= 0.5; E14=1; t=0.5;
                E21=cn; E22=cn; E23=0.5; E24=0.5;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  b3=b(3); b4 =b(4);   
                     c1=c(1);  c2=c(2); c3=c(3); 
                     d1 =d(1); d2=d(2); d3=d(3);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12>=1+cn; z12<=Lmax+1; 
                                     z21==1+cn; z22==1+cn; z23>=1+cn; z23<=Lmax+1;
                                      z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax; 
                                      z24>=z23;    z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z12+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z12^(-1))/d2)^d2)*((z13^(-1))/d3)^d3;
                                          R2*(1+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))+z23+(z23^(-2))*z24+((z23^(-1))*(z14^(-1))) <= (((CC2+1)/b1)^b1)*(((z23^(-1))/b2)^b2)*(((((z14)^(-1))*z23)/b3)^b3)*(((((z14)^(-1))*z24*(z23^(-2)))/b4)^b4);
                                          1+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z23)^(-1)))/c3)^c3); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE X ENDS %%%% CASE X ENDS%%%%%%%%%%%
            elseif ((i==3)&&(j==3))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=0.5; E13= 0.75; E14=1.5; t=0.5;
                E21=cn; E22=0.75; E23=1; E24=1;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2); b3=b(3); b4=b(4); b5=b(5); b6=b(6);
                     c1=c(1);  c2=c(2); c3=c(3); c4=c(4); 
                     d1 =d(1); d2=d(2); d3=d(3);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12>=1+cn;  z12<=Lmax+1; 
                                     z21==1+cn; z22>=1+cn;  z22<=Lmax+1;
                                      z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax;
                                      z23>=z22;  z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z12+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z12^(-1))/d2)^d2)*((z13^(-1))/d3)^d3;
                                          R2*(1+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))*(1+(z22^(-1))+(z23^(-1)))+z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*(((z22^(-1))/b2)^b2)*(((z23^(-1))/b3)^b3)*(((((z14)^(-1))*z22)/b4)^b4)*(((((z14)^(-1))*z23*((z22)^(-2)))/b5)^b5)*(((((z14)^(-1))*z24*((z23)^(-2)))/b6)^b6);
                                          1+(z22^(-1))+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z22)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z23)^(-1)))/c4)^c4); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE XI ENDS %%%% CASE XI ENDS%%%%%%%%%%%
            elseif ((i==3)&&(j==4))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=cn; E12=0.5; E13= 0.75; E14=1.5; t=0.5;
                E21=0.5; E22=0.5; E23=0.75; E24=1;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2); b3=b(3); b4=b(4); b5=b(5); b6=b(6); b7=b(7); b8=b(8); 
                     c1=c(1);  c2=c(2); c3=c(3); c4=c(4); c5=c(5); 
                     d1 =d(1); d2=d(2); d3=d(3);
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11==1+cn; z12>=1+cn; z12<=Lmax+1; 
                                     z21>=1+cn; z21<=Lmax+1;
                                     z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax;
                                     z22>=z21;  z22*(z21^(-1))<= 1+Lmax; z23>=z22;  z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z12+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z12^(-1))/d2)^d2)*((z13^(-1))/d3)^d3;
                                          R2*(1+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))*(1+((z21)^(-1))+((z22)^(-1))+((z23)^(-1)))+z21+ ((z21)^(-2))*z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*((((z21)^(-1))/b2)^b2)*((((z22)^(-1))/b3)^b3)*((((z23)^(-1))/b4)^b4)*(((((z14)^(-1))*z21)/b5)^b5)*(((((z14)^(-1))*z22*((z21)^(-2)))/b6)^b6)*(((((z14)^(-1))*z23*((z22)^(-2)))/b7)^b7)*(((((z14)^(-1))*z24*((z23)^(-2)))/b8)^b8);
                                          1+(z21^(-1))+(z22^(-1))+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z21)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z22)^(-1)))/c4)^c4)*(((((z14)^(-1))*((z23)^(-1)))/c5)^c5); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE XII ENDS %%%% CASE XII ENDS%%%%%%%%%%%
        elseif ((i==4)&&(j==1))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=0.5; E12=0.75; E13=1; E14=1; t=0.5;
                E21=cn; E22=cn; E23=cn; E24=0.5;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  
                     c1=c(1);  c2=c(2);
                     d1 =d(1); d2=d(2); d3=d(3); d4=d(4);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn; z11<=Lmax+1; 
                                     z21==1+cn; z22==1+cn; z23==1+cn; z24>=1+cn; z24<=Lmax+1;
                                     z12>=z11;  z12*(z11^(-1))<= 1+Lmax; z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax;                                        
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z11+(z12*z11^(-2))+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z11^(-1))/d2)^d2)*(((z12^(-1))/d3)^d3)*(((z13^(-1))/d4)^d4);
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))+z24 <= (((CC2+1)/b1)^b1)*((((z14)^(-1))*z24)/b2)^b2;
                                          R3 <= ((CC3/c1)^c1)*((R3*((z14)^(-1))/c2)^c2); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
                  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE XIII ENDS %%%% CASE XIII ENDS%%%%%%%%%%%
                  elseif ((i==4)&&(j==2))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=0.5; E12=0.75; E13=1; E14=1; t=0.5;
                E21=cn; E22=cn; E23=0.5; E24=1;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);  
                     b1=b(1);  b2=b(2);   b3=b(3); b4=b(4); 
                     c1=c(1);  c2=c(2);   c3=c(3); 
                     d1=d(1);  d2=d(2);   d3=d(3); d4=d(4);
                     
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn; z11<=Lmax+1; 
                                     z21==1+cn; z22==1+cn; z23>=1+cn; z23<=Lmax+1;
                                     z12>=z11;  z12*(z11^(-1))<= 1+Lmax; z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax; 
                                     z24>=z23;    z24*(z23^(-1))<= 1+Lmax;

                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*((((z14^(-1))*(z24^(-1)))/a2)^a2);
                                          z11+(z12*z11^(-2))+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z11^(-1))/d2)^d2)*(((z12^(-1))/d3)^d3)*(((z13^(-1))/d4)^d4);
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))+z23+(z23^(-2))*z24+((z23^(-1))*(z14^(-1))) <= (((CC2+1)/b1)^b1)*(((z23^(-1))/b2)^b2)*(((((z14)^(-1))*z23)/b3)^b3)*(((((z14)^(-1))*z24*(z23^(-2)))/b4)^b4);
                                          1+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z23)^(-1)))/c3)^c3);
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
                  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE XIV ENDS %%%% CASE XIV ENDS%%%%%%%%%%%
                  elseif ((i==4)&&(j==3))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=0.5; E12=0.5; E13=1; E14=1; t=0.5;
                E21=cn; E22=0.5; E23=0.75; E24=1;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);   b3=b(3); b4=b(4);  b5=b(5); b6=b(6); 
                     c1=c(1);  c2=c(2);   c3=c(3); c4=c(4); 
                     d1=d(1);  d2=d(2);   d3=d(3); d4=d(4);
                    if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn;  z11<=Lmax+1; 
                                     z21==1+cn; z22>=1+cn; z22<=Lmax+1;
                                     z12>=z11;  z12*(z11^(-1))<= 1+Lmax; z13>=z12;  z13*(z12^(-1))<= 1+Lmax; z14>=z13;  z14*(z13^(-1))<= 1+Lmax; 
                                     z23>=z22; z23*(z22^(-1))<= 1+Lmax; z24>=z23; z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z11+(z12*z11^(-2))+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z11^(-1))/d2)^d2)*(((z12^(-1))/d3)^d3)*(((z13^(-1))/d4)^d4);
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))*(1+(z22^(-1))+(z23^(-1)))+z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*(((z22^(-1))/b2)^b2)*(((z23^(-1))/b3)^b3)*(((((z14)^(-1))*z22)/b4)^b4)*(((((z14)^(-1))*z23*((z22)^(-2)))/b5)^b5)*(((((z14)^(-1))*z24*((z23)^(-2)))/b6)^b6);
                                          1+(z22^(-1))+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z22)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z23)^(-1)))/c4)^c4); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
                  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE XV ENDS %%%% CASE XV ENDS%%%%%%%%%%%
           else 
                ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=0.5; E12=0.75; E13=1; E14=1; t=0.5;
                E21=0.25; E22=0.5; E23=1; E24=1;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11*(1+E12); z13=z12*(1+E13); z14=z13*(1+E14);
                z21=1+E21; z22=z21*(1+E22); z23=z22*(1+E23); z24=z23*(1+E24);
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,d ] = coeff_ARQ_ff_global( z,Lmax,i,j,CC1,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);   b3=b(3); b4=b(4); b5=b(5); b6=b(6); b7=b(7); b8=b(8);  
                     c1=c(1);  c2=c(2);     c3=c(3);  c4=c(4);  c5=c(5); 
                     d1=d(1);  d2=d(2);   d3=d(3); d4=d(4);
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn; z11<=Lmax+1; 
                                     z21>=1+cn; z21<=Lmax+1;
                                     z12>=z11;  z12*(z11^(-1))<= 1+Lmax; z13>=z12;  z13*(z12^(-1))<= 1+Lmax;  z14>=z13;  z14*(z13^(-1))<= 1+Lmax; 
                                     z22>=z21;  z22*(z21^(-1))<= 1+Lmax; z23>=z22;  z23*(z22^(-1))<= 1+Lmax;  z24>=z23;   z24*(z23^(-1))<= 1+Lmax;
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z11+(z12*z11^(-2))+(z13*z12^(-2))+(z14*z13^(-2)) <= (((CC1+1)/d1)^d1)*(((z11^(-1))/d2)^d2)*(((z12^(-1))/d3)^d3)*(((z13^(-1))/d4)^d4);
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1)))+ ((z14)^(-1))*(1+((z21)^(-1))+((z22)^(-1))+((z23)^(-1)))+z21+ ((z21)^(-2))*z22+ ((z22)^(-2))*z23+ ((z23)^(-2))*z24 <= (((CC2+1)/b1)^b1)*((((z21)^(-1))/b2)^b2)*((((z22)^(-1))/b3)^b3)*((((z23)^(-1))/b4)^b4)*(((((z14)^(-1))*z21)/b5)^b5)*(((((z14)^(-1))*z22*((z21)^(-2)))/b6)^b6)*(((((z14)^(-1))*z23*((z22)^(-2)))/b7)^b7)*(((((z14)^(-1))*z24*((z23)^(-2)))/b8)^b8);
                                          1+(z21^(-1))+(z22^(-1))+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z21)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z22)^(-1)))/c4)^c4)*(((((z14)^(-1))*((z23)^(-1)))/c5)^c5);
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=(z12/z11)-1; E13=(z13/z12)-1; E14=(z14/z13)-1;
                    E21=z21-1; E22=(z22/z21)-1; E23=(z23/z22)-1; E24=(z24/z23)-1;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                    ER = E_new;
                 end
                 %p=[p1 p2 p3 p4];
                 %ell;
            end         
        t;
        pol = [E11 E12 E13 E14 E21 E22 E23 E24];
        i;
        j;
        z=[z11 z12 z13 z14 z21 z22 z23 z24];
        if (((obj<=t)))
        pol = [E11 E12 E13 E14 E21 E22 E23 E24];
        obj=t;
        end  
        
end

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TESTING PART
E11 =pol(1); E12=pol(2); E13=pol(3); E14=pol(4); E21 =pol(5); E22=pol(6); E23=pol(7); E24=pol(8);
for l=1:8
    if (pol(l)==0)
        x(l)=0;
    else
        x(l)=1;
    end
end
    
x1=x(1); x2=x(2); x3=x(3); x4=x(4); x5=x(5); x6=x(6); x7=x(7); x8=x(8); 
diff1 =E11+(E12/(1+E11))+(E13/(1+E12+E11))+(E14/(1+E11+E12+E13))-CC1;
diff2 = R2*(x1+x2*(1/(1+E11))+x3*(1/(1+E11+E12))+x4*(1/(1+E11+E12+E13)))+(1-(1/(1+E11+E12+E13+E14)))*(E21+(E22/(1+E21))+(E23/(1+E21+E22))+(E24/(1+E21+E22+E23)))-CC2;
diff3 = (1-(1/(1+E21+E22+E23+E24)))*R3*(x5+x6*(1/(1+E21))+x7*(1/(1+E21+E22))+x8*(1/(1+E21+E22+E23)))-CC3;
E= pol
 x;       
end


