%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [ a,b,c,e,f ] = coeff_ARQ_sf_slotalloc_new( z,i,j,CC2,CC3,R3,Lmax)
% This function calculates the coefficients to solve for optimal power allocation using GP 
% for ARQ SLOW FADING channel
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ a,b,c,e,f ] = coeff_ARQ_sf_slotalloc_new( z,i,j,CC2,CC3,R3,Lmax)
%This function calculates the coefficients to solve for optimal power allocation using GP 
%for ARQ SLOW FADING channel

if ((i==5)&&(j==1))
    z11=z(1);  z14=z(4);
    z12=z(2);  z15=z(5);
    z13=z(3);  z21=z(6);
     
    DEN1 = 1+(z15^(-1))*(z21^(-1)); 
    DEN2 = CC2+1+((z15)^(-1))*z21;
    DEN3=  CC3+R3*(z15^(-1));
    DEN51 = z11+Lmax; DEN52 = z12+Lmax; DEN53 = z13+Lmax; DEN54 = z14+Lmax; 
    %DEN4 = CC1+1+z11^(-1)+z12^(-1)+z13^(-1);
            a1 =1/DEN1;
            a2=((z15^(-1))*(z21^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+1)/DEN2;
            b2 = (((z15)^(-1))*z21)/DEN2;
    b=[b1 b2];
            c1 = CC3/DEN3;
            c2 = (R3*(z15^(-1)))/DEN3;
    c=[c1 c2];
%             d1 = (CC1+1)/DEN4;
%             d2 = (z12^(-1))/DEN4;
%             d3 = (z13^(-1))/DEN4;
%             d4 = (z13^(-1))/DEN4;
%     d=[d1 d2 d3 d4];
            e1 = Lmax/DEN51;
            e2 =  z11/DEN51;
            e3 = Lmax/DEN52;
            e4 =  z12/DEN52;
            e5 = Lmax/DEN53;
            e6 =  z13/DEN53;
            e7 = Lmax/DEN54;
            e8 =  z14/DEN54;
    e= [e1 e2 e3 e4 e5 e6 e7 e8];
 
    f=0;
    
elseif ((i==4)&&(j==2)) %%%%%%%%%%%%%%%%%%%%% CASE II %%%%%%%% CASE II %%%%%%%%%%%
    z11=z(1);  z14=z(4);
    z12=z(2);  z23=z(5);
    z13=z(3);  z24=z(6);
    DEN1 = 1+(z14^(-1))*(z24^(-1)); 
    DEN2 = CC2+2+((z14)^(-1))*(z23+z24*(z23^(-1)));
    DEN3=  (CC3/R3)+(z14^(-1))*(1+z23^(-1));
    DEN51 = z11+Lmax; DEN52 = z12+Lmax; DEN53 = z13+Lmax; 
    DEN6 = z23+Lmax;
   %DEN4 = CC1+1+z11^(-1)+z12^(-1)+z13^(-1);
            a1 =1/DEN1;
            a2=((z14^(-1))*(z24^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+2)/DEN2;
            b2 = (((z14)^(-1))*z23)/DEN2;
            b3 = ((z14)^(-1))*(z24*(z23^(-1)))/DEN2;
    b=[b1 b2 b3 ];
            c1 = CC3/(R3*DEN3);
            c2 = (z14^(-1))/DEN3;
            c3 = ((z14^(-1))*(z23^(-1)))/DEN3;
    c=[c1 c2 c3];
%             d1 = (CC1+1)/DEN4;
%             d2 = (z12^(-1))/DEN4;
%             d3 = (z13^(-1))/DEN4;
%             d4 = (z13^(-1))/DEN4;
%     d=[d1 d2 d3 d4];
            e1 = Lmax/DEN51;
            e2 =  z11/DEN51;
            e3 = Lmax/DEN52;
            e4 =  z12/DEN52;
            e5 = Lmax/DEN53;
            e6 =  z13/DEN53;
    e= [e1 e2 e3 e4 e5 e6];
            f1 = Lmax/DEN6;
            f2 =  z23/DEN6;
    f=[f1 f2];
    
    
    elseif ((i==3)&&(j==3)) %%%%%%%%%%%%%%%%%%%%%%%%%%%% CASE III %%%% CASE III
    z12=z(1);  z22=z(4);
    z13=z(2);  z23=z(5);
    z14=z(3);  z24=z(6);
    
    DEN1 = 1+(z14^(-1))*(z24^(-1)); 
    DEN2 = CC2+3+((z14)^(-1))*(z22+z23*z22^(-1)+z24*(z23^(-1)));%(z22^(-1))+(z23^(-1))+
    DEN3=  (CC3/R3)+(z14^(-1))*(1+(z22^(-1))+z23^(-1));
    DEN51 = z12+Lmax; DEN52 = z13+Lmax; 
    DEN61 = z22+Lmax; DEN62 = z23+Lmax;
    %DEN4 = CC1+1+z12^(-1)+z13^(-1);
            a1 =1/DEN1;
            a2=((z14^(-1))*(z24^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+3)/DEN2;
            b2 = (((z14)^(-1))*z22)/DEN2;
            b3 = ((z14)^(-1))*(z23*(z22^(-1)))/DEN2;
            b4 = ((z14)^(-1))*(z24*(z23^(-1)))/DEN2;
%             b5 = (z22^(-1))/DEN2;
%             b6 = (z23^(-1))/DEN2;           
    b=[b1 b2 b3 b4];
            c1 = CC3/(R3*DEN3);
            c2 = (z14^(-1))/DEN3;
            c3 = ((z14^(-1))*(z22^(-1)))/DEN3;
            c4 = ((z14^(-1))*(z23^(-1)))/DEN3;
    c=[c1 c2 c3 c4];
%             d1 = (CC1+1)/DEN4;
%             d2 = (z12^(-1))/DEN4;
%             d3 = (z13^(-1))/DEN4;
%     d=[d1 d2 d3];
            e1 = Lmax/DEN51;
            e2 =  z12/DEN51;
            e3 = Lmax/DEN52;
            e4 =  z13/DEN52;
    e= [e1 e2 e3 e4];
            f1 = Lmax/DEN61;
            f2 =  z22/DEN61;
            f3 = Lmax/DEN62;
            f4 =  z23/DEN62;
    f=[f1 f2 f3 f4];
    elseif ((i==2)&&(j==4))  %%%%%%%%%%%%%%%%%%%%%%%%%%%% CASE IV %%%% CASE IV %%%%%%%%%%%%%%%%%%%55
    z13=z(1);  z22=z(4);
    z14=z(2);  z23=z(5);
    z21=z(3);  z24=z(6);
    DEN1 = 1+(z14^(-1))*(z24^(-1)); 
    DEN2 = CC2+4+((z14)^(-1))*(z21+z22*((z21)^(-1))+z23*((z22)^(-1))+z24*((z23)^(-1)));%+((z21)^(-1))+((z22)^(-1))+((z23)^(-1))
    DEN3=  (CC3/R3)+(z14^(-1))*(1+(z21^(-1))+(z22^(-1))+z23^(-1));
    DEN5 = z13+Lmax; 
    DEN61 = z21+Lmax; DEN62 = z22+Lmax; DEN63 = z23+Lmax; 
    %DEN4 = CC1+1+z13^(-1);
    
            a1 =1/DEN1;
            a2=((z14^(-1))*(z24^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+4)/DEN2;
            b2 = (((z14)^(-1))*z21)/DEN2;
            b3 = (((z14)^(-1))*z22*((z21)^(-1)))/DEN2;
            b4 = (((z14)^(-1))*z23*((z22)^(-1)))/DEN2;
            b5 = (((z14)^(-1))*z24*((z23)^(-1)))/DEN2;
%             b6 = ((z21)^(-1))/DEN2;
%             b7 = ((z22)^(-1))/DEN2;
%             b8 = ((z23)^(-1))/DEN2; 
    b=[b1 b2 b3 b4 b5];
            c1 = CC3/(R3*DEN3);
            c2 = ((z14^(-1)))/DEN3;
            c3 = ((z14^(-1))*((z21)^(-1)))/DEN3;
            c4 = ((z14^(-1))*((z22)^(-1)))/DEN3;
            c5 = ((z14^(-1))*((z23)^(-1)))/DEN3;
    c=[c1 c2 c3 c4 c5];
%             d1 = (CC1+1)/DEN4;
%             d2 = (z13^(-1))/DEN4;
%     d=[d1 d2];
            e1 = Lmax/DEN5;
            e2 =  z13/DEN5;
    e= [e1 e2];
            f1 = Lmax/DEN61;
            f2 =  z21/DEN61;
            f3 = Lmax/DEN62;
            f4 =  z22/DEN62;
            f5 = Lmax/DEN63;
            f6 =  z23/DEN63;
    f= [f1 f2 f3 f4 f5 f6];
    
   elseif ((i==1)&&(j==5))  %%%%%%%%%%%%%%%%%%%%%%% CASE V  %%%%%%%%% CASE V
    z14=z(1);  z23=z(4);
    z21=z(2);  z24=z(5);
    z22=z(3);  z25=z(6);
    DEN1 = 1+(z14^(-1))*(z25^(-1)); 
    DEN2 = CC2+5+((z14)^(-1))*(z21+z22*((z21)^(-1))+z23*((z22)^(-1))+z24*((z23)^(-1))+z25*((z24)^(-1)));%+((z21)^(-1))+((z22)^(-1))+((z23)^(-1))
    DEN3 =  (CC3/R3)+(z14^(-1))*(1+z21^(-1)+z22^(-1)+z23^(-1)+z24^(-1));
    DEN61 = z21+Lmax;
    DEN62 = z22+Lmax;
    DEN63 = z23+Lmax;
    DEN64 = z24+Lmax;
            a1 =1/DEN1;
            a2=((z14^(-1))*(z25^(-1)))/DEN1;
    a=[a1 a2];
            b1 = (CC2+4)/DEN2;
            b2 = (((z14)^(-1))*z21)/DEN2;
            b3 = (((z14)^(-1))*z22*((z21)^(-1)))/DEN2;
            b4 = (((z14)^(-1))*z23*((z22)^(-1)))/DEN2;
            b5 = (((z14)^(-1))*z24*((z23)^(-1)))/DEN2;
            b6 = (((z14)^(-1))*z25*((z24)^(-1)))/DEN2;
%             b6 = ((z21)^(-1))/DEN2;
%             b7 = ((z22)^(-1))/DEN2;
%             b8 = ((z23)^(-1))/DEN2; 
    b=[b1 b2 b3 b4 b5 b6];
            c1 = CC3/(R3*DEN3);
            c2 = (z14^(-1))/DEN3;
            c3 = (z14^(-1))*(z21^(-1))/DEN3;
            c4 = (z14^(-1))*(z22^(-1))/DEN3;
            c5 = (z14^(-1))*(z23^(-1))/DEN3;
            c6 = (z14^(-1))*(z24^(-1))/DEN3;
    c=[c1 c2 c3 c4 c5 c6];
            f1 = Lmax/DEN61;
            f2 = z21/DEN61;  
            f3 = Lmax/DEN62; 
            f4 = z22/DEN62;
            f5 = Lmax/DEN63; 
            f6 = z23/DEN63;
            f7 = Lmax/DEN64; 
            f8 = z24/DEN64;
    
    d=0; e=0; f= [f1 f2 f3 f4 f5 f6 f7 f8];
    
    end


end

