%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [ Lvec, LvR ] = opt_policy_Geo_global_test( rhot, 
% rhor, rho3, Lmax, Es, K1,K2,R2,R3,el_max,epsilon)
% This function find the optimal policy by exhaustively 
% searching over all possible integer combinations. 
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [ Lvec, LvR ] = opt_policy_Geo_global_test( rhot, rhor, rho3, Lmax, Es, K1,K2,R2,R3,el_max,epsilon)

cn=1e-10;
obj=1e-30;
CC1=(K1+K2)*rhot*Es-0.05;
CC2=(K1+K2)*rhor*Es-0.05;
CC3= (K1+K2)*rho3*Es;
i=4; j=4; 

ell=0;
                E_diff=[1 1 1 1 1 1 1 1];
                E11=0.25; E12=0.5; E13= 0.75; E14=1.5; t=0.5;
                E21=0.25; E22=0.5; E23=1; E24=2;
                E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                z11=1+E11; z12=z11+E12; z13=z12+E13; z14=z13+E14;
                z21=1+E21; z22=z21+E22; z23=z22+E23; z24=z23+E24;
                z=[z11 z12 z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,e,f ] = coeff_sf_global( z,Lmax,i,j,CC2,CC3,R3); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);   b3=b(3); b4=b(4); b5=b(5); 
                     c1=c(1);  c2=c(2);   c3=c(3); c4=c(4); c5=c(5); %                     d1=d(1);  d2=d(2);   d3=d(3); d4=d(4);
                     e1=e(1);  e2=e(2);   e3=e(3); e4=e(4); e5=e(5); e6=e(6); 
                     f1=f(1);  f2=f(2);   f3=f(3); f4=f(4); f5=f(5); f6=f(6); 
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn; z12>=z11+cn; z13>=z12+cn; z14>=z13+cn; z11<=Lmax+1; 
                                     z21>=1+cn; z22>=z21+cn; z23>=z22+cn; z24>=z23+cn; z21<=Lmax+1;
                                     z12<=((Lmax/e1)^e1)*((z11/e2)^e2);  z13<=((Lmax/e3)^e3)*((z12/e4)^e4); z14<=((Lmax/e5)^e5)*((z13/e6)^e6); 
                                     z22<=((Lmax/f1)^f1)*((z21/f2)^f2); z23<=((Lmax/f3)^f3)*((z22/f4)^f4);  z24<=((Lmax/f5)^f5)*((z23/f6)^f6);
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z11+(z12*z11^(-1))+(z13*z12^(-1))+(z14*z13^(-1)) <= CC1+4; %(((CC1+1)/d1)^d1)*((z11^(-1))/d2)^d2*((z12^(-1))/d3)^d3*((z13^(-1))/d4)^d4;
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1)))+ 4*((z14)^(-1))+z21+ ((z21)^(-1))*z22+ ((z22)^(-1))*z23+ ((z23)^(-1))*z24 <= (((CC2+4)/b1)^b1)*(((((z14)^(-1))*z21)/b2)^b2)*(((((z14)^(-1))*z22*((z21)^(-1)))/b3)^b3)*(((((z14)^(-1))*z23*((z22)^(-1)))/b4)^b4)*(((((z14)^(-1))*z24*((z23)^(-1)))/b5)^b5);
                                          1+(z21^(-1))+(z22^(-1))+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z21)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z22)^(-1)))/c4)^c4)*(((((z14)^(-1))*((z23)^(-1)))/c5)^c5);
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z21 z22 z23 z24];
                    E11=z11-1; E12=z12-z11; E13=z13-z12; E14=z14-z13;
                    E21=z21-1; E22=z22-z21; E23=z23-z22; E24=z24-z23;
                    E_new=[E11 E12 E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                    ER = E_new;
                 end
LvR=[0 0 0 0 0 0 0 0];
Lvec = [E11 E12 E13 E14 E21 E22 E23 E24];
end

