%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [ E ] = opt_policy_sf_slotalloc_relaxed( rhot, 
% rhor, rho3, Lmax, Es, K1,K2,R2,R3,el_max,epsilon)
% This function finds the optimal policy by relaxing 
% the integer constraints for
% the nodes for various slot allocation
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [ E ] = opt_policy_sf_slotalloc_relaxed( rhot, rhor, rho3, Lmax, Es, K1,K2,R2,R3,el_max,epsilon)

cn=1e-10;
obj=1e-30;
CC1=(K1+K2)*rhot*Es-0.05;
CC2=(K1+K2)*rhor*Es-0.05;
CC3= (K1+K2)*rho3*Es;

        if((K1==5)&&(K2==1))
         
                 ell=0;
                E_diff=[1 1 1 1 1 1];
                E11=0.5; E12=0.75; E13=1; E14=1;  E15=1; t=0.5;
                E21=0.5;
                E_new=[E11 E12 E13 E14 E15 E21];
                z11=1+E11; z12=z11+E12; z13=z12+E13; z14=z13+E14; z15=z14+E15;
                z21=1+E21; 
                z=[z11 z12 z13 z14 z15 z21];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                     [ a,b,c,e,f] = coeff_ARQ_sf_slotalloc_new( z,K1,K2,CC2,CC3,R3,Lmax); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  
                     c1=c(1);  c2=c(2);%                     d1 =d(1); d2=d(2); d3=d(3); d4=d(4);
                     e1=e(1);  e2=e(2); e3=e(3); e4=e(4); e5=e(5); e6=e(6); e7=e(7); e8=e(8); 
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z15 z21 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn; z11<=Lmax+1; z12>=z11;  z13>=z12;  z14>=z13;  z15>=z14;  
                                     z21>=1+cn; z21<=Lmax+1;
                                     z12<=((Lmax/e1)^e1)*((z11/e2)^e2);  z13<=((Lmax/e3)^e3)*((z12/e4)^e4); z14<=((Lmax/e5)^e5)*((z13/e6)^e6); z15<=((Lmax/e7)^e7)*((z14/e8)^e8);
                                                                             
                                          t+(z15^(-1))+(z21^(-1))<=((1/a1)^a1)*(((z15^(-1))*(z21^(-1)))/a2)^a2;
                                                                               
                                          z11+(z12*z11^(-1))+(z13*z12^(-1))+(z14*z13^(-1))+(z15*z14^(-1)) <= CC1+5; % (((CC1+1)/d1)^d1)*((z11^(-1))/d2)^d2*((z12^(-1))/d3)^d3*((z13^(-1))/d4)^d4;
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1))+(z14^(-1)))+ ((z15)^(-1))+z21 <= (((CC2+1)/b1)^b1)*((((z15)^(-1))*z21)/b2)^b2;
                                          R3 <= ((CC3/c1)^c1)*((R3*((z15)^(-1))/c2)^c2); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z15 z21];
                    E11=z11-1; E12=z12-z11; E13=z13-z12; E14=z14-z13; E15=z15-z14;
                    E21=z21-1;  
                    E_new=[E11 E12 E13 E14 E15 E21];
                    E_diff=E_new-E_old;
                 end
                  
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASEI ENDS %%%% CASE I ENDS%%%%%%%%%%%  
            elseif ((K1==4)&&(K2==2))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1 ];
                E11=0.5; E12=0.75; E13=1; E14=1; t=0.5;
                E23=0.5; E24=1; 
                E_new=[E11 E12 E13 E14 E23 E24];
                z11=1+E11; z12=z11+E12; z13=z12+E13; z14=z13+E14;
                z23=1+E23; z24=z23+E24; 
                z=[z11 z12 z13 z14 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c,e,f ] = coeff_ARQ_sf_slotalloc_new( z,K1,K2,CC2,CC3,R3,Lmax); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);  
                     b1=b(1);  b2=b(2);   b3=b(3); 
                     c1=c(1);  c2=c(2);   c3=c(3); %                     d1=d(1);  d2=d(2);   d3=d(3); d4=d(4);
                     e1=e(1);  e2=e(2);   e3=e(3); e4=e(4); e5=e(5); e6=e(6); 
                     f1=f(1);  f2=f(2);
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z11 z12 z13 z14 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z11>=1+cn; z12>=z11+cn; z13>=z12+cn; z14>=z13+cn; z11<=Lmax+1; 
                                     z23>=1+cn; z24>=z23+cn; z23<=Lmax+1;
                                     z12<=((Lmax/e1)^e1)*((z11/e2)^e2);  z13<=((Lmax/e3)^e3)*((z12/e4)^e4); z14<=((Lmax/e5)^e5)*((z13/e6)^e6); 
                                     z24<=((Lmax/f1)^f1)*((z23/f2)^f2);
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z11+(z12*z11^(-1))+(z13*z12^(-1))+(z14*z13^(-1)) <= CC1+4;% (((CC1+1)/d1)^d1)*((z11^(-1))/d2)^d2*((z12^(-1))/d3)^d3*((z13^(-1))/d4)^d4;
                                          R2*(1+(z11^(-1))+(z12^(-1))+(z13^(-1)))+ 2*((z14)^(-1))+z23+(z23^(-1))*z24 <= (((CC2+2)/b1)^b1)*(((((z14)^(-1))*z23)/b2)^b2)*(((((z14)^(-1))*z24*(z23^(-1)))/b3)^b3);
                                          1+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z23)^(-1)))/c3)^c3);
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z11 z12 z13 z14 z23 z24];
                    E11=z11-1; E12=z12-z11; E13=z13-z12; E14=z14-z13;
                    E23=z23-1; E24=z24-z23;
                    E_new=[E11 E12 E13 E14 E23 E24];
                    E_diff=E_new-E_old;
                 end
                  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE II ENDS %%%% CASE II ENDS%%%%%%%%%%%
                   elseif ((K1==3)&&(K2==3))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1];
                E12=0.5; E13= 0.75; E14=1.5; t=0.5;
                E22=0.75; E23=1; E24=1;
                E_new=[E12 E13 E14 E22 E23 E24];
                z12=1+E12; z13=z12+E13; z14=z13+E14;
                z22=1+E22; z23=z22+E23; z24=z23+E24;
                z=[z12 z13 z14 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c,e,f ] = coeff_ARQ_sf_slotalloc_new( z,K1,K2,CC2,CC3,R3,Lmax); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  b3=b(3); b4=b(4);
                     c1=c(1);  c2=c(2);  c3=c(3); c4=c(4); %                     d1 =d(1); d2=d(2); d3=d(3);
                     e1=e(1);  e2=e(2);  e3=e(3); e4=e(4); 
                     f1=f(1);  f2=f(2);  f3=f(3); f4=f(4); 
                     E_old=E_new; 
                     if ((a1==0) || (a2==0))
                         t=1e-30;
                         break
                     end
                 cvx_begin gp quiet
                        variables z12 z13 z14 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z12>=1+cn; z13>=z12+cn; z14>=z13+cn; z12<=Lmax+1; 
                                     z22>=1+cn; z23>=z22+cn; z24>=z23+cn; z22<=Lmax+1;
                                      z13<=((Lmax/e1)^e1)*((z12/e2)^e2); z14<=((Lmax/e3)^e3)*((z13/e4)^e4);
                                      z23<=((Lmax/f1)^f1)*((z22/f2)^f2); z24<=((Lmax/f3)^f3)*((z23/f4)^f4);
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z12+(z13*z12^(-1))+(z14*z13^(-1)) <= CC1+3; %(((CC1+1)/d1)^d1)*((z12^(-1))/d2)^d2*((z13^(-1))/d3)^d3;
                                          R2*(1+(z12^(-1))+(z13^(-1)))+ 3*((z14)^(-1))+z22+ ((z22)^(-1))*z23+ ((z23)^(-1))*z24 <= (((CC2+3)/b1)^b1)*(((((z14)^(-1))*z22)/b2)^b2)*(((((z14)^(-1))*z23*((z22)^(-1)))/b3)^b3)*(((((z14)^(-1))*z24*((z23)^(-1)))/b4)^b4);
                                          1+(z22^(-1))+(z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z22)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z23)^(-1)))/c4)^c4); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z12 z13 z14 z22 z23 z24];
                    E12=z12-1; E13=z13-z12; E14=z14-z13;
                    E22=z22-1; E23=z23-z22; E24=z24-z23;
                    E_new=[E12 E13 E14 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
                 
                 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CASE III ENDS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CASE III ENDS %%%%%%%%%%%%%%%%%%%%%%%%%%
                 
            elseif ((K1==2)&&(K2==4))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1];
                E13= 0.5;  E14=1; t=0.5;
                E21= 0.25; E22=0.5; E23= 1; E24=2;
                E_new=[E13 E14 E21 E22 E23 E24];
                z13=1+E13; z14=z13+E14;
                z21=1+E21; z22=z21+E22; z23=z22+E23; z24=z23+E24;
                z=[z13 z14 z21 z22 z23 z24];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while (epsilon<=(norm(E_diff,2))&&(ell<=el_max))
                      ell=ell+1;
                   [ a,b,c,e,f ] = coeff_ARQ_sf_slotalloc_new( z,K1,K2,CC2,CC3,R3,Lmax); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1);  a2=a(2);   
                     b1=b(1);  b2=b(2);  b3=b(3); b4=b(4); b5=b(5); 
                     c1=c(1);  c2=c(2);  c3=c(3); c4=c(4); c5=c(5); %                     d1 =d(1); d2=d(2);
                     e1=e(1);  e2=e(2); 
                     f1= f(1); f2=f(2); f3=f(3); f4=f(4); f5=f(5); f6=f(6);
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z13 z14 z21 z22 z23 z24 t                                    
                        maximize (t)        
                                     subject to  
                                     z13>=1+cn; z14>=z13+cn; z13<=Lmax+1; 
                                     z21>=1+cn; z22>=z21+cn; z23>=z22+cn; z24>=z23+cn; z21<=Lmax+1;
                                     z14<=((Lmax/e1)^e1)*((z13/e2)^e2); 
                                     z22<=((Lmax/f1)^f1)*((z21/f2)^f2); z23<=((Lmax/f3)^f3)*((z22/f4)^f4); z24<=((Lmax/f5)^f5)*((z23/f6)^f6);
                                          t+(z14^(-1))+(z24^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z24^(-1)))/a2)^a2;
                                          z13+(z14*z13^(-1)) <= CC1+2;
                                          R2*(1+z13^(-1))+ 4*((z14)^(-1))+z21+ ((z21)^(-1))*z22+ ((z22)^(-1))*z23+ ((z23)^(-1))*z24 <= (((CC2+4)/b1)^b1)*(((((z14)^(-1))*z21)/b2)^b2)*(((((z14)^(-1))*z22*((z21)^(-1)))/b3)^b3)*(((((z14)^(-1))*z23*((z22)^(-1)))/b4)^b4)*(((((z14)^(-1))*z24*((z23)^(-1)))/b5)^b5);
                                          (1+z21^(-1)+z22^(-1)+z23^(-1)) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*(((((z14)^(-1))*((z21)^(-1)))/c3)^c3)*(((((z14)^(-1))*((z22)^(-1)))/c4)^c4)*(((((z14)^(-1))*((z23)^(-1)))/c5)^c5); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z13 z14 z21 z22 z23 z24];
                    E13=z13-1; E14=z14-z13;
                    E21=z21-1; E22=z22-z21; E23=z23-z22; E24=z24-z23;
                    E_new=[E13 E14 E21 E22 E23 E24];
                    E_diff=E_new-E_old;
                 end
             
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CASE IV ENDS %%%% CASE IV ENDS%%%%%%%%%%%  
            elseif ((K1==1)&&(K2==5))
        %%%%%%%%%%% Initial Vector
                ell=0;
                E_diff=[1 1 1 1 1 1];
                E14=0.4; t=0.5;
                E21=0.5; E22=1; E23= 1.5; E24=2; E25=1;
                E_new=[E14 E21 E22 E23 E24 E25];
                z14=1+E14; 
                z21=1+E21; z22=z21+E22; z23=z22+E23; z24=z23+E24; z25=z24+E25;
                z=[z14 z21 z22 z23 z24 z25];
                
                            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Solving the Signomial Program 
                 while ((epsilon<=(norm(E_diff,2)))&&(ell<=el_max))
                      ell=ell+1;
                    [ a,b,c,e,f ] = coeff_ARQ_sf_slotalloc_new( z,K1,K2,CC2,CC3,R3,Lmax); %%%%%%%%%%%%%%%%% Coeff calculates the optimal alpha_i for approximating the denominator posynomial
                     a1=a(1); a2=a(2);   
                     b1=b(1); b2=b(2);  b3=b(3); b4=b(4); b5=b(5); b6=b(6);
                     c1=c(1);  c2=c(2); c3=c(3); c4=c(4); c5=c(5); c6=c(6); 
                     f1 =f(1); f2=f(2); f3=f(3); f4=f(4); f5=f(5); f6=f(6);  f7=f(7); f8=f(8); 
                     E_old=E_new; 
                 cvx_begin gp quiet
                        variables z14 z21 z22 z23 z24 z25 t                                    
                        maximize (t)        
                                     subject to  
                                     z21>=1+cn; z22>=z21+cn; z23>=z22+cn; z24>=z23+cn; z25>=z24+cn; z21<=Lmax+1;
                                     z14<=Lmax+1; z14>=1+cn; 
                                      z22<= ((Lmax/f1)^f1)*((z21/f2)^f2); z23<= ((Lmax/f3)^f3)*((z22/f4)^f4); z24<= ((Lmax/f5)^f5)*((z23/f6)^f6); z25<= ((Lmax/f7)^f7)*((z24/f8)^f8);
                                          t+(z14^(-1))+(z25^(-1))<=((1/a1)^a1)*(((z14^(-1))*(z25^(-1)))/a2)^a2;
                                          z14 <= CC1+1;
                                          R2+5*((z14)^(-1))+z21+ ((z21)^(-1))*z22+ ((z22)^(-1))*z23+ ((z23)^(-1))*z24+ ((z24)^(-1))*z25 <= (((CC2+5)/b1)^b1)*(((((z14)^(-1))*z21)/b2)^b2)*(((((z14)^(-1))*z22*((z21)^(-1)))/b3)^b3)*(((((z14)^(-1))*z23*((z22)^(-1)))/b4)^b4)*(((((z14)^(-1))*z24*((z23)^(-1)))/b5)^b5)*(((((z14)^(-1))*z25*((z24)^(-1)))/b6)^b6);
                                          1+z21^(-1)+z22^(-1)+z23^(-1)+z24^(-1) <= ((CC3/(R3*c1))^c1)*((((z14)^(-1))/c2)^c2)*((((z14)^(-1))*(z21^(-1))/c3)^c3)*((((z14)^(-1))*(z22^(-1))/c4)^c4)*((((z14)^(-1))*(z23^(-1))/c5)^c5)*((((z14)^(-1))*(z24^(-1))/c6)^c6); 
                cvx_end
                                %%%%%%%%Diff between old and new   %%%%%%%%%%%%%%%%%%%%%%%solution
                    z=[z14 z21 z22 z23 z24 z25];
                    E14=z14-1;
                    E21=z21-1; E22=z22-z21; E23=z23-z22; E24=z24-z23; E25=z25-z24;
                    E_new=[E14 E21 E22 E23 E24 E25];
                    E_diff=E_new-E_old;
                 end
             
             
            
        
       end
pol=E_new;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TESTING PART
% E11 =pol(1); E12=pol(2); E13=pol(3); E14=pol(4); E21 =pol(5); E22=pol(6); E23=pol(7); E24=pol(8);
% for l=1:6
%     if (pol(l)==0)
%         x(l)=0;
%     else
%         x(l)=1;
%     end
% end
%     
% x1=x(1); x2=x(2); x3=x(3); x4=x(4); x5=x(5); x6=x(6); x7=x(7); x8=x(8); 
% diff1 =E11+(E12/(1+E11))+(E13/(1+E12+E11))+(E14/(1+E11+E12+E13))-CC1;
% diff2 = R2*(x1+x2*(1/(1+E11))+x3*(1/(1+E11+E12))+x4*(1/(1+E11+E12+E13)))+(1-(1/(1+E11+E12+E13+E14)))*(E21+(E22/(1+E21))+(E23/(1+E21+E22))+(E24/(1+E21+E22+E23)))-CC2;
% diff3 = (1-(1/(1+E21+E22+E23+E24)))*R3*(x5+x6*(1/(1+E21))+x7*(1/(1+E21+E22))+x8*(1/(1+E21+E22+E23)))-CC3;
E= pol
 %x;       
end


