%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function f = myfun_sf(t,Kp,m,Lmax,Eav)
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function f = myfun_sf(t,Kp,m,Lmax,Eav)
% This provides a handle for the function whose zero have to find out in
% order to obtain the optimal policy conforming to the peak power
% constraint

if ((m==Kp-1)&&(Kp==2))
    
    f = Eav-(Lmax/(1+t))-t;
    
elseif ((m==Kp-1)&&(Kp==3))
    
    f = Eav-(Lmax/(1+t))-(Lmax/(1+t+Lmax))-t; 
    
elseif ((m==Kp-1)&&(Kp==4))
    
    f = Eav-(Lmax/(1+t))-(Lmax/(1+t+Lmax))-(Lmax/(1+t+2*Lmax))-t; 
    
   
elseif ((m==1)&&((Kp==3)||(Kp==4)))
    
    f= ((1+(1/(Kp-m))*(Eav-(Lmax/(1+t))))^(Kp-m))-t-1;
    
elseif ((Kp==4)&&(m==2))
    
    f= ((1+(1/(Kp-m))*(Eav-(Lmax/(1+t))-(Lmax/(1+t+Lmax))))^(Kp-m))-t-1;
    
else
    
    f=Eav-1/t;
    
end
    


end

