%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This program computes the PDP for a multihop fast fading EH link empirically. 
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all 
close all 
NumPkt 	 	    = 	1e7;                                        % no of packets
rho1 			= 	0.05:0.05:1;                                     % probability of energy harvesting at source node
rho2            =   0.3;
rho3            =   0.3;
Es_db			=   3;   % 8 dB corresponds to 200 microJoule  Energy harvested per slot under the setting considered in the paper. These values are equivalent to the settings considered in the paper
Es 			    =   10^(Es_db/10);                                  % Energy harvested per slot
B1              =   3;                                                     % battery capacity
B2              =   3;
B3              =   3;
K 			    = 	2;                                                         % Max no of slots
Tp              =   1;                                                        % Packet Duration
R               =   1;
Lmax            =   10*Es; 
epsilon         =   1e-5;
el_max          =   100;
K1              =   K;
K2              =   K;
R2              =   R;
R3              =   R;
os1            = 0.005;                               % change the variables os1 and os2 to control the size of the battery
os2            = 0.005;

for rhot = rho1                                        % Loop is running for all  rho values
       
        rhoidt 		= 	find(rhot == rho1)
       
        hprocess1 	= 	(rand(1,NumPkt*(K1+K2)) <= rhot);
    for rhor = rho2  
        
        rhoidr 		= 	find(rhor == rho2);
        hprocess2 	= 	(rand(1,NumPkt*(K1+K2)) <= rhor);
        hprocess3 	= 	(rand(1,NumPkt*(K1+K2)) <= rho3);
        BT1         = 	3;  BT2  =   3; BT3 = 3; BTR1= 3; BTR2 = 3; BTR3 =3; 
        
 Lvec1 =  [1 1]; 
 Lvec2 =  [1 1];
 
        NumAck(rhoidt,rhoidr)	= 	0;
        NumAck1(rhoidt,rhoidr)  =   0;
       % NumAckR(rhoidt,rhoidr)	= 	0;
        ell(rhoidt)=0;
 for pac= 1:NumPkt
     ACK1 	= 	0; ACK2=0;  ACKR1=0; ACKR2=0;
     
     i=0; ir=0;
     for kk = 0:K1-1                                              % Loop is running for a frame
		BT1  =   min(BT1+hprocess1((pac-1)*(K1+K2)+kk+1),B1);
        BT2  =   min(BT2+hprocess2((pac-1)*(K1+K2)+kk+1),B2);
        BT3  =   min(BT3+hprocess3((pac-1)*(K1+K2)+kk+1),B3);
%         BTR1 =   min(BTR1+hprocess1((pac-1)*(K1+K2)+kk+1),B1);
%         BTR2 =   min(BTR2+hprocess2((pac-1)*(K1+K2)+kk+1),B2);
%         BTR3 =   min(BTR3+hprocess3((pac-1)*(K1+K2)+kk+1),B3);
        gamma 	= 	exprnd(1);
			if ((BT1 >=Lvec1(i+1)) && (ACK1 == 0) &&(BT2>=R2) )
				BT1 	= 	BT1 - Lvec1(i+1);
                BT2     =   BT2-R2;                
                %sk=sk+(Lvec(i+1)*gamma);
                Pe = exp(-(gamma*Lvec1(i+1)*Es/Tp));
                ACK1 = (Pe<=rand(1,1));
                i=i+1;
                %ell=ell+1;
				%ACK 	= 	(rand(1,1) >= Pe);
            end
            end
     i=0; ir=0;
    for kk=0:K2-1
        BT1  =   min(BT1+hprocess1((pac-1)*(K1+K2)+K1+kk+1),B1);
        BT2  =   min(BT2+hprocess2((pac-1)*(K1+K2)+K1+kk+1),B2);
        BT3  =   min(BT3+hprocess3((pac-1)*(K1+K2)+K1+kk+1),B3);
%         BTR1 =   min(BTR1+hprocess1((pac-1)*(K1+K2)+K1+kk+1),B1);
%         BTR2 =   min(BTR2+hprocess2((pac-1)*(K1+K2)+K1+kk+1),B2);
%         BTR3 =   min(BTR3+hprocess3((pac-1)*(K1+K2)+K1+kk+1),B3);
        gamma 	= 	exprnd(1);
            if ((BT2 >=Lvec2(i+1)) && (ACK1 == 1) && (ACK2==0) &&(BT3>=R3) )
				BT2 	= 	BT2 - Lvec2(i+1);
                BT3     =   BT3-R3;                
                %sk=sk+(Lvec(i+1)*gamma);
                Pe = exp(-(gamma*Lvec2(i+1)*Es/Tp));
                ACK2 = (Pe<=rand(1,1));
                i=i+1;
				%ACK 	= 	(rand(1,1) >= Pe);
            end
            
    end
    
       NumAck(rhoidt,rhoidr)	= 	NumAck(rhoidt,rhoidr) + ACK2;
       NumAck1(rhoidt,rhoidr)	= 	NumAck1(rhoidt,rhoidr) + ACK1;
       
 
 end
 %NumAck
 % ell
 
    end
end
Out = ones(length(rho1),length(rho2)) -NumAck/NumPkt;    % calculating the outage probability prob of success =  total no of ACK / Total no of packets.
Out2= ones(length(rho1),length(rho2))- NumAck./NumAck1;

fname = ['mat/Multihop_PDP_R2_',num2str(R2),'_R3_',num2str(R3),'_Es_',num2str(Es_db),'_K1_',num2str(K1),'_K2_',num2str(K2),'quantz',datestr(now,'mmmm_dd_yy_HH_MM_SS'),'.mat'];
eval(['save ', fname,' rho2 rho3 Lvec1 Lvec2 Out Out2']);