%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function res = cprod(varargin)
% Cartesian product Matlab implementation
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     
    function res = cprod(varargin)
        res = [];
        if nargin >= 1
            x = varargin{1};
            x = x(:);
            if nargin == 1
                res = x;
                return;
            end
            y = varargin(2:end);
            y = cprod(y{:});
           
            nx = size(x, 1);
            ny = size(y, 1);
            rx = repmat(x.', ny, 1);
            ry = repmat(y, nx, 1);
            res = [rx(:), ry];
        end
    end

