%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function Pout = EHR_outprobKgiveni_Lvec_barq_sf(K1,K2,ii,jj,
% hh,Tp, Es,rhot,rhor,rho3, Lvec1,Lvec2, R,BT1,BT2,BT3, gamma1,gamma2)
% 
% This function builds the conditional outage Probability in the slow fading case
%
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function Pout = EHR_outprobKgiveni_Lvec_barq_sf(K1,K2,ii,jj,hh,Tp, Es,rhot,rhor,rho3, Lvec1,Lvec2, R,BT1,BT2,BT3, gamma1,gamma2)
% 	This function builds the conditional outage Probability in the slow fading case

Pouti=0;
%W=1/L;
%Pe=Pe(1);
Lvec1 =[0 Lvec1];
Lvec2 = [0 Lvec2];
m=0;
% X=sprintf ('Analysis for BT1=%d and BT2=%d and BT3= %d and rho1=%g  and rho2 =%g and rho3 =%g', hh, ii, jj, rhot, rhor,rho3 );
% disp(X)
% UB ='--------------------------------------------------------------------------------------------------------------------------------------------------------------------------';
% disp(UB)
% disp(' it1 |  ir2 | it2 | ir3 | Eavt1 | Eavr2 | Eavt2 | Eavr3 | ACCPT1| ACCPR1 | ACCPR2 | ACCPT2 |Psi1 | Psi2 | Pe1 | Pe2 | b | Pouti ')
% disp(UB)
for it1= 0:K1
    Eavt1=min(hh+it1,BT1);
    for ir2 = 0:K1
            Eavr2=min(ii+ir2,BT2);
            ACCPT1=0;
            ACCPR1 =0;
            Pe1=1;
            Psi1=1;
                for l=0:K1
                   ACCPT1=ACCPT1+Lvec1(l+1);
                   ACCPR1 = l*R;
                       if ((Eavt1-ACCPT1 >=0)&&(Eavr2-ACCPR1>=0))
                                Psi1=l;
                                Pe1=Pe1*exp(-(gamma1*Es*Lvec1(l+1)/Tp));
                       else
                                m=m+1;
                       end
                end
    for it2 =0:K2
            Eavt2 =min(max(Eavr2-Psi1*R+it2,0),BT2);
        for ir3 =0:K2
            Eavr3=min(jj+ir3,BT3);
            ACCPT2=0;
            ACCPR2 =0;
            Pe2=1;
            Psi2=1;
                 for n=0:K2
                    ACCPT2=ACCPT2+Lvec2(n+1);
                    ACCPR2 = n*R;
                        if ((Eavt2-ACCPT2 >=0)&&(Eavr3-ACCPR2>=0))
                                Psi2=n;
                                Pe2=Pe2*exp(-(gamma2*Es*Lvec2(n+1)/Tp));
                        else
                            m=m+1;
                        end
                 end
                Pe= Pe1+(1-Pe1)*Pe2;
     
     b=nchoosek(K1,it1)*nchoosek(K1,ir2)*nchoosek(K2,it2)*nchoosek(K2,ir3)*((rhot)^it1)*((1-rhot)^(K1-it1))*((rhor)^ir2)*((1-rhor)^(K1-ir2))*((rhor)^it2)*((1-rhor)^(K2-it2))*((rho3)^ir3)*((1-rho3)^(K2-ir3))*Pe;
    Pouti=Pouti+b;
    
%     %%%%%%%%%%%%%%%% For Debugging
%     Y=  sprintf(' %d |  %d | %d | %d | %d | %d | %d | %d | %d| %d | %d | %d | %d | %d | %g | %g | %g | %g ', it1, ir2, it2,ir3,Eavt1,Eavr2, Eavt2,Eavr3, ACCPT1,ACCPR1,ACCPR2,ACCPT2,Psi1,Psi2,Pe1,Pe2,b,Pouti);
%             disp(Y)
%             disp(UB)
%    %%%%%%%%%%%%%%%%%%
        end
      end
    end
end
Pout = Pouti;
end
