%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This code evaluates the PDP using the analytical expressions
% provided in the the paper. 
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all; close all
%delta 			= 	10;
rho1	    =   0.05:0.05:1;
rho2 		= 	0.3;
rho3        =   0.3;
BT1 		= 	3;   % Maximum battery size allowed is BT=7; 
BT2         =   3;
BT3         =   3;
K           =   2;
K1		    = 	K;
K2          =   K;
Es_db	    = 	8;
Es 			=   10^(Es_db/10);
NumIter		= 	1e3;
Lvec1		= 	[1 1];
Lvec2       =   [1 1]; 
R           =   1;
Tp          =   1;
qt1         =   1;
qt2         =   1;
qt3         =   1; 
st1         =   1/qt1;
st2         =   1/qt2;
st3         =   1/qt3;
ssp         = (K1+1)*(K2+2)*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)*(max(K1,K2)); 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%E			= 	Es/L;
r 			= 	-2:1:(K2-1);
m           =   -1:1:(K1-1);
h1          =    0:qt1:BT1; 
i1 		    = 	 0:qt2:BT2;                                        % For fraction L
j1          =    0:qt3:BT3;
ind1        =    0:max(K1,K2)-1;
%i=0:1:BT;                                                            % For integer L
s 			=   -2:1:(K2-1);
n           =   -1:1:(K1-1);
h2          =   0:qt1:BT1;
i2          =   0:qt2:BT2;
j2			=	0:qt3:BT3;                                        % For fraction L
ind2        =   0:max(K1,K2)-1;
%j=0:1:BT;                                                            % for integer L  
res 			= 	cprod(ind2,n,s,j2,i2,h2,ind1,m,r,j1,i1,h1);                              % i will be more frequent one here we get it as    1010, 1011, 1012, .... 101BT, 1000, 1001.... -(K-1)BT(-(K-1))BT
                                                                           % where, these 4-tuple represents (s,j,r,i) pairs.
     l=0;                                                                      
[h w] 	= 	size(res);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CODE TO FIND THE index of invalid
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% STATEs%%%%%%%%%%%%%
%INV=zeros(ssp,1);
A=res(1:ssp,7:12);
INV=((A(:,2)==-1)&(A(:,3)>A(:,1)))|((A(:,1)==0)&(A(:,2)==-1)&(A(:,3)==-1))|((((A(:,2)==-1)&(A(:,1)==0))|(A(:,2)>A(:,1)))&(A(:,3)==-2))|((A(:,2)~=-1)&(A(:,3)==-1))|((A(:,2)~=-1)&(A(:,3)>0));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Pe 	= 	getpe(Tp,Lvec,Es,Tsnr,h);                              % For basic ARQ    
%clear res 
for rhot = rho1
	Gavg 			= 	0;
	Pavg 			= 	0;
    
	ridt			= 	find(rhot == rho1)
    for rhor = rho2
        ridr			= 	find(rhor == rho2);
        tic
	parfor iter = 1:NumIter
		%tic
	   l=l+1;
        Pout 	= 	zeros(1,(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1));                            % Pout is a 1 x ((2*BT+1)*(2*BR+1)) matrix  containing (2*BT+1)*(2*BR+1) zeros.
		gamma1 	= 	exprnd(1);                              % will generate a exponantial random variable with mean 1.    
        gamma2 	= 	exprnd(1);
		%%%%%%%%%%%%%%%%%%%% Transition Probabilty Matrix%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
		 
       G1 	= 	tpm_MH_sf_Lvec(rhot,rhor, rho3, Lvec1, Lvec2, gamma1, gamma2, BT1,BT2,BT3, K1, K2, res, Es,R,Tp);              % find transition probability for basic ARQ for integer L.
       %G1 	= 	tpm_ehr_harq_CC_sf_Lvec(rhot,rhor,Lvec,BR,BT,K,res,Tp,Es,Tsnr,Pr);
        
		%G 	= 	reshape(G,(K+1)*(BT+1),(K+1)*(BT+1)); % reshape(X,M,N) returns the M-by-N matrix whose elements
                                                                                        %are taken columnwise from X.  An error results if X does
                                                                                       %not have M*N elements. Here it is [(K+1)*(BT+1)]  x [(K+1)*(BT+1)] matrix. The first column of this
                                                                                        % matrix gives the porbabilities of transition  from any (r,i) pair to (1,0).  second column gives the 
           G1 	= 	reshape(G1,[ssp,ssp]);                                             % probabilities of transition form any pair to (1,1) and so on.
		  G1=G1(~INV,:);
         G1=G1(:,~INV);
           
           GK 	= 	G1^(K1+K2);                                                           % K-step transition probabilities Pr[(B(m+1)K =j),U(m+1)K=s | BmK =i, UmK=r], refer theorem 2.1 in AK's Book.
                                                                                        % Note that GK also have dimension [(BT+1)x(K+1)] X [(BT+1)x(K+1)]
           %GK(:,1:(K1+1)*(K2+2)*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1))= GK(:,1:(K1+1)*(K2+2)*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1))+GK(:,(K1+1)*(K2+2)*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)+1:2*(K1+1)*(K2+2)*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1));                                                                          
               
           %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
           %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
           % for ind2=0:1 we are accumulating the probabilities. As starting from initial state with ind1=0 the DTMC can go to the state with ind1=0 or ind1=1                                                                         
           %%% Next, we want to add                                                                            
                                                                                        
                                                                                        
                                                                                        
                                                                                        
		for ii = [0 2:(K1+1)*(K2+2)/2]                                                           % loop runs for [0 2 3 ......K] 
			GK(:,(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)+1:2*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1))	= 	GK(:,(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)+1:2*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1))+GK(:,ii*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)+1:(ii+1)*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)); %After this for loop finishes running for all values
                          % of ii we will get Pr[B(m+1)K =j | BmK= i, UmK=r] for any -(K-1)<r<1.we are partially implementing eqn(31) in anup's paper
		end
		GK2	= 	GK((st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)+1:2*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1),(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1)+1:2*(st1*BT1+1)*(st2*BT2+1)*(st3*BT3+1));    % As we are only intrested in Pr[(B(m+1)K=j | BmK =i, r=0)] so we pick only that 
                                                                                   % As from row number BT+2 : 2*BT+2 we have r=0. 
		Gavg 	= 	Gavg + GK2/NumIter;                 %As it is accessing the same memory location so in the Gavg will be tum of all GK2 corresponding to each gamma and divided by Numiter. By dividing it with Numiter it is averaging it out wrt all channel instantiations. 
		a=0;
        
    %%%%%%%%%%%%%%%%%%%%%%%OUT AGE PROBABILITY CALCULATION GIVEN BATTERY    %%%%%%%%%%%%%%%%%%%%%%%STATE
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        for jj = j1                                                               %  runs for each battery state and finds the outage probabiltiy for that state Pout(K|i,y).
			%a=a+1;
            
            for ii =i1 
                for hh=h1
                a=a+1;
           
            %Pout(a)	= 	outageprobKgiveni_Lvec_barq_ff(K,ii,Tsnr,Tp, Es,rho,Lvec);           % For basic ARQ integer L
                    Pout(a)	= 	EHR_outprobKgiveni_Lvec_barq_sf(K1,K2,ii,jj,hh,Tp, Es,rhot,rhor,rho3, Lvec1,Lvec2, R,BT1,BT2,BT3, gamma1,gamma2);
            %Pout(a)	= 	EHR_outprobKgiveni_Lvec_harq_CC_sf(K,ii,jj,Tsnr,Tp, Es,rhot,rhor,Lvec,Pr);
                end
            end
        end
		Pavg 	= 	Pavg + Pout/NumIter;                % channel averaged outage probability.
		%toc
    end
    toc
    
   GK2 =Gavg^1000000000;
    pip =GK2(1,:);
   
%    Q=eye(2*BT+1)-GK2;
%    QT=Q.';
%    pip =null(QT);
%  	Q 		= 	GK2 -  eye(2*BT+1);                            % As per eqn (26) in anup's paper we have to solve pi =piG  
%  	QT		= 	Q.';                                                    % or Transpose(pi) = Transpose(G)*Transpose(pi) or (Transpose(G) - eye(BT+1)) =0
%  	QT(end,:)	= 	ones(1,2*BT+1);                          %They replace the last eqn by pi1+pi2+....piBt=1, so that you still have BT+1 equations with BT+1 variables. Last row is being replaced by ones to give that eqn 
%  	b	= 	[zeros(1,2*BT) 1]';           % linsolve(A,B) solves the system of linear equations Ax=B. In our case we is a all zero vector except last entry as 1.
%  [pip resn]=lsqnonneg(QT,b); 	                        %x = lsqnonneg(C,d) returns the vector x that minimizes norm(C*x-d) subject to x >= 0. C and d must real
     Poutage(ridt,ridr) 	= 	Pavg*pip'                            % implementing eqn(26) to find Pout(K) = Pout(K|n)*pin summed over all n.
     Pouta(l,:) = Pavg;
     pipa(l,:)=pip;
   end
end
Lstr =  mat2str(Lvec1);                                           %mat2str(A) converts matrix A into a string.
Lstr =  strrep(Lstr,'.','pt');                                      %Find and replace substring. Here it replace '.' by 'pt' 
Lstr =  strrep(Lstr,' ','_');                                       % Replace spcae in Lstr by _
Lstr =  strrep(Lstr,'[','_');                                       % Replace left and right paranthese by _
Lstr =  strrep(Lstr,']','_');
Lstr1 =mat2str(Lvec2);
Lstr1 =  strrep(Lstr,'.','pt');                                      %Find and replace substring. Here it replace '.' by 'pt' 
Lstr1 =  strrep(Lstr,' ','_');                                       % Replace spcae in Lstr by _
Lstr1 =  strrep(Lstr,'[','_');                                       % Replace left and right paranthese by _
Lstr1=  strrep(Lstr,']','_');
fname = ['mat/closed_sf_barq_anylt2','_Lvec1_',Lstr,'_Lvec2_',Lstr1,'_rho2_',num2str(rho2),'_Es_',num2str(Es_db),'_Cap_',num2str(BT1),'_K_',num2str(K),'_R_',num2str(R),'quantz',datestr(now,'mmmm_dd_yy_HH_MM_SS'),'.mat'];
%fname = ['lpehs_anylt','_pktsize_',num2str(delta),'_L1_',num2str(L1),'_L2_',num2str(L2),'.mat'];
eval(['save ', fname, ' rho2 rho3 Poutage']);
clear res r m h1 i1 j1 ind1 ind2 j2 i2 h2 n s
 