%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function G = tpm_MH_sf_Lvec(rho1,rho2, rho3, Lvec1, Lvec2, gamma1, gamma2, 
% BT1,BT2,BT3, K1, K2, res, Es,Pr,Tp) 
% 
% (calculate the probability of transition from (i,r) to (j,s))
% Generates the Transition probability matrix for the DTMC describing the
% evolution of the multi-hop link in slow fading case. This is later used
% to find the stationary distribution
% 
% Author: Mohit K. Sharma
% Email: mohit.sharma987@gmail.com
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function G = tpm_MH_sf_Lvec(rho1,rho2, rho3, Lvec1, Lvec2, gamma1, gamma2, BT1,BT2,BT3, K1, K2, res, Es,Pr,Tp) 

%(calculate the probability of transition from (i,r) to (j,s))
% gerates Transition probability matrix for the DTMC describing the
% evolution of the multi-hop link in slow fading case. This is later used
% to find the stationary distribution

Lvec1	 = 	    [0 Lvec1] ;
Lvec2    =      [0 0  Lvec2];

ind2          =       res(:,1)';
n            =       res(:,2)';
s 	          = 	  res(:,3)';                                                   % (BT+1)^2 X (K+1) repetitions of array 1:-1:-(K-1) with 1 as first element and -(K-1) as last element
j2 	          = 	  res(:,4)';                                                     %(K+1)^2 X (BT+1) repetitions of array 0:BT with zero as first element and BT as last 
i2 	          = 	  res(:,5)';                                                    % order of frequency (rapidness of change) here is fs<fj<fr<fi
h2            = 	  res(:,6)';                                                    % order of frequency (rapidness of change) here is fs<fj<fr<fi
ind1          =       res(:,7)';
m	          = 	  res(:,8)';
r           =       res(:,9)';
j1            =       res(:,10)';
i1            =       res(:,11)';
h1            =       res(:,12)';
 
[h w] 	      = 	  size(res);
%W=1/L;                                                              % Amount of units obtained by node with one instance of energy harvesting.
G	= 	zeros(1,h);                                              % G has zeros in it and size is 1 x (no. of states) A ROW Vector
I	= 	ones(1,h);


flag1 	       =  (((r==-2)&(ind1<K1-1)&(ind2==ind1+1)&(s==-2)&(m>=0)&(m<K1-1))|((0<=m)&(m<=K1-1)&(r==-2)&(ind1==K1-1)&(ind2==0)&(s==0)))&((h1>=Lvec1(m+2))&(i1>=Pr));                                                                                        % CASE 1:  Packet has not reached the node and subframe 1 is not over and the battery has sufficient charge.              
flag21       =  (((r==-2)&(ind1<K1-1)&(ind2==ind1+1)&(s==-2)&(m>=0)&(m<K1-1))|((0<=m)&(m<=K1-1)&(r==-2)&(ind1==K1-1)&(ind2==0)&(s==0)))&((h1>=Lvec1(m+2))&(Pr-1<=i1)&(i1<Pr));                                                                               % SUBCASE 21:  Packet has not reached the node and subframe 1 is not over and only the transmitter's battery has sufficient charge while the receiver requires one more unit.
flag22       =  (((r==-2)&(ind1<K1-1)&(ind2==ind1+1)&(s==-2)&(m>=0)&(m<K1-1))|((0<=m)&(m<=K1-1)&(r==-2)&(ind1==K1-1)&(ind2==0)&(s==0)))&((Lvec1(m+2)>h1)&(h1>=Lvec1(m+2)-1)&(Pr<=i1));                                                                               % SUBCASE 21:  Packet has not reached the node and subframe 1 is not over and only the receiver's battery has sufficient charge while the transmitter requires one more unit.
flag23       =  (((r==-2)&(ind1<K1-1)&(ind2==ind1+1)&(s==-2)&(m>=0)&(m<K1-1))|((0<=m)&(m<=K1-1)&(r==-2)&(ind1==K1-1)&(ind2==0)&(s==0)))&((Lvec1(m+2)>h1)&(h1>=Lvec1(m+2)-1)&(Pr-1<=i1)&(i1<Pr));                                                                               % SUBCASE 21:  Packet has not reached the node and subframe 1 is not over and only the receiver's battery has sufficient charge while the transmitter requires one more unit.
%f3=flag22&flag23;
%f2=flag21&flag22;
%f2=reshape(f2,[192 192]);
%f1=flag1&flag21;
%find(f1~=0)
%find(f2~=0)
%find(f3~=0)
flag31       =  (m==-1)&((ind2==ind1+1)&(ind1<K2-1)&(r>=0)&(r<K2-1))&((i1>=Lvec2(r+3))&(j1>=Pr));                                                                       % SUBCASE 13: the packet has reached the node 2 and the subframe 1 is just over but one of the node does not have sufficient energy
flag311      =  (m==-1)&(n==0)&((ind1==K2-1)&(ind2==0)&(r>=0)&(s==-2))&((i1>=Lvec2(r+3))&(j1>=Pr));
flag32	     = 	(m==-1)&(((ind2==ind1+1)&(ind1<K2-1)&(r>=0)&(r<K2-1)))&((i1>=Lvec2(r+3))&(Pr-1<=j1)&(j1<Pr));                                                                         % CASE 3:   When the packet has reached node2 but not at the destination and either node2 or node 3 doesn't have sufficient energy to supoort an attempt. 
flag321      =  (m==-1)&(n==0)&((ind1==K2-1)&(ind2==0)&(r>=0)&(s==-2))&((i1>=Lvec2(r+3))&(Pr-1<=j1)&(j1<Pr));   
flag33	     = 	(m==-1)&((ind2==ind1+1)&(ind1<K2-1)&(r>=0)&(r<K2-1))&((Lvec2(r+3)>i1)&(i1>=Lvec2(r+3)-1)&(Pr<=j1));
flag331      =  (m==-1)&(n==0)&((ind1==K2-1)&(ind2==0)&(r>=0)&(s==-2))&((Lvec2(r+3)>i1)&(i1>=Lvec2(r+3)-1)&(Pr<=j1));
flag34	     = 	(m==-1)&(((ind2==ind1+1)&(ind1<K2-1)&(r>=0)&(r<K2-1)))&((Lvec2(r+3)>i1)&(i1>=Lvec2(r+3)-1)&(Pr-1<=j1)&(j1<Pr));
flag341      =  (m==-1)&(n==0)&((ind1==K2-1)&(ind2==0)&(r>=0)&(s==-2))&((Lvec2(r+3)>i1)&(i1>=Lvec2(r+3)-1)&(Pr-1<=j1)&(j1<Pr));
% f3=flag32&flag33;
% % f2=flag31&flag34;
% % f2=reshape(f2,[192 192]);
% % f1=flag31&flag32;
% % find(f1~=0)
% % find(f2~=0)
% find(f3~=0)
% flag4	     = 	((m==-1)&(r ~=-1))&((i1>=Lvec1(m+2))&(j1>=Pr));                                                                      % CASE 4:  when the packet has reached node 2 but has not reached node 3. 
flag51       =  (0<=m)&(m<K1)&(m==n)&((h1<Lvec1(m+2)-1)|(i1<Pr-1))&(ind1<K1-1)&(ind2==ind1+1)&(r==-2)&(s==-2);               % SUBCASE 51:  Packet has not reached the node 2 and subframe 1 is not over    but battery DOES NOT HAVE SUFFICIENT charge             
flag511      =  (0<=m)&(m<K1)&(m==n)&((h1<Lvec1(m+2)-1)|(i1<Pr-1))&(ind1==K1-1)&(ind2==0)&(r==-2)&(s==0);
%flag52       = 	(m==-1)&(r==-2)&(m==n)&(ind1<K1-1)&(ind2==ind1+1)&(s==-2);                                                                                                          % SUBCASE 52:  Packet has reached the node2 but subframe 1 is not over
flag52      = 	(m==-1)&(r==-2)&(m==n)&(ind1==K1-1)&(ind2==0)&(s==0);
flag53       =  (m==-1)&(m==n)&(ind1<K2-1)&(ind1>=0)&(ind2==ind1+1)&(r<=ind1)&(r>=0)&(s==r)&((i1<Lvec2(r+3)-1)|(j1<Pr-1));                                                          % SUBCASE 53: the packet has reached the node 2 and the subframe 1 is just over but one of the node does not have sufficient energy
flag531      =  (m==-1)&(n==0)&(ind1==K2-1)&(ind2==0)&(r>=0)&(s==-2)&((i1<Lvec2(r+3)-1)|(j1<Pr-1));
flag54       = 	(m==-1)&(r==-1)&(m==n)&(ind1>0)&(ind1<K1-1)&(ind2==ind1+1)&(s==-1);                                                                                                          % SUBCASE 52:  Packet has reached the node2 but subframe 1 is not over
flag541      = 	(m==-1)&(r==-1)&(ind1==K1-1)&(ind2==0)&(s==-2)&(n==0);
flag5        =  (flag51|flag511|flag52|flag53|flag531|flag54|flag541);                                    % CASE 6: When packet has been received successfully at node 3. 
flag6        =  (((m~=-1)&(0<=ind1)&(ind1<K2-1)&(ind2==ind1+1)&(r==0)&(s==0)&(n==m))|((m~=-1)&(ind1==K2-1)&(ind2==0)&(r==0)&(s==-2)&(n==0))) ;                            % CASE 6:  Packet has not reached the node 2 and subframe 1 is over    
g=flag5&flag6;
find(g~=0);
% flag5 = ((Lvec2(r+3)<=i1)&(r~=-1)&(j1<Pr)&(Pr-1<=j1));                                    % CASE 3
% flag6 = (((Lvec2(r+3)-1)<=i1)&(i1<(Lvec2(r+3)))&(r~=-1)&(j1<Pr)&(Pr-1<=j1));   % CASE 4
%r1    	= 	min(i+L,Lvec(-(r-2)));                          % as r may very from 1:-(K-1), for r=0 it chooses Lvec(2)=1 and for r=-1 Lvec(3)=2 and for r=-2 Lvec(4) =3 an 
%r2 	= 	min(i,Lvec(-(r-2)));	                               % and for r=1 it chooses Lvec(1) =0 and for r=-3 (after 3rd slot) it chooses Lvec(5) =4. where, i is the battery level.
%Pe 	= 	getpe(Tp,L,Es,Tsnr,h);               % we choose r1 when energy is harvested 
%Pe2 	= 	getpe(gamma,delta,r2*E);               %we choose r2 when no energy is harvested
Lv1          =   Lvec1(m+2);
Lv2          =   Lvec2(r+3);
Pe1          =   getpe(Tp,Lv1,Es,gamma1);
Pe2          =   getpe(Tp,Lv2,Es,gamma2); 

%%%%%%%%%%%%%%%%%%%%%%% flag1 % Subframe one is not over and packet has not
%%%%%%%%%%%%%%%%%%%%%%% reached node 2. In addition, both the nodes has
%%%%%%%%%%%%%%%%%%%%%%% sufficient energy to support the attempt. 

G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3)*flag1.*(h2==h1-Lvec1(m+2)).*(i2==i1-Pr).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                               % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag1.*(h2==h1-Lvec1(m+2)).*(i2==i1-Pr).*(j2==j1).*(1-Pe1).*(n ==-1);                         % 000 
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag1.*(h2==h1-Lvec1(m+2)).*(i2==i1-Pr).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));                       % 001 
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag1.*(h2==h1-Lvec1(m+2)).*(i2==i1-Pr).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);                  % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag1.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));                % 011
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag1.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);           % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));           % 111
G 	= G 	+ 	rho1*rho2*rho3.*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);      % 111 
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                  % 110
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*(1-Pe1).*(n ==-1);             % 110   
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));                  % 101
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);             % 101    
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                         % 100
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag1.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==j1).*(1-Pe1).*(n ==-1);                    % 100
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag1.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                         % 010  
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag1.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*(1-Pe1).*(n ==-1);                    % 010

%%%%%%%%%%%% flag21 (SubCase 21)    % Transmitter has sufficient charge
%%%%%%%%%%%% while receiver require one more unit of energy
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag21.*(h2==h1).*(i2==i1).*(j2==j1).*(n ==m);                                                % 000  
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag21.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3)).*(n == m);                                        % 001
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag21.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m);                                    % 101    
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag21.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1).*(n ==m);                                           % 100
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag21.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));               % 011
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag21.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);          % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag21.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));          % 111 
G 	= G 	+ 	rho1*rho2*rho3.*flag21.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);     % 111  
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag21.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                 % 110
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag21.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*(1-Pe1).*(n ==-1);            % 110
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag21.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                        % 010   
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag21.*(h2==h1-Lvec1(m+2)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*(1-Pe1).*(n ==-1);                   % 010   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% flag22 (subcase 22)  % Receiver has
%%%%%%%% sufficient energy but transmiiter need one more unit of energy
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag22.*(h2==h1).*(i2==i1).*(j2==j1).*(n ==m);                                                % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag22.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m);                                         % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag22.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==min(j1+1,BT3)).*(n ==m);                                  % 011     
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag22.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1).*(n ==m);                                           % 010  
G 	= G 	+ 	rho1*rho2*rho3.*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));          % 111    
G 	= G 	+ 	rho1*rho2*rho3.*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);     % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                 % 110
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*(1-Pe1).*(n ==-1);            % 110
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));                 % 101
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);            % 101
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                        % 100
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag22.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==i1-Pr).*(j2==j1).*(1-Pe1).*(n ==-1);                   % 100

%%%%%%%%%%%%%%% flag 23  (subcase 23)
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag23.*(h2==h1).*(i2==i1).*(j2==j1).*(n ==m);                                               % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag23.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m);                                        % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag23.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==min(j1+1,BT3)).*(n ==m);                                 % 011
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag23.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m);                                   % 101 
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag23.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1).*(n ==m);                                          % 100     
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag23.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1).*(n ==m);                                          % 010 
G 	= G 	+ 	rho1*rho2*rho3.*flag23.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*Pe1.*(n ==min(m+1,K1-1));         % 111
G 	= G 	+ 	rho1*rho2*rho3.*flag23.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==min(j1+1,BT3)).*(1-Pe1).*(n ==-1);    % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag23.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*Pe1.*(n ==min(m+1,K1-1));                % 110   
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag23.*(h2==min(h1+1-Lvec1(m+2),BT1)).*(i2==min(i1+1-Pr,BT2)).*(j2==j1).*(1-Pe1).*(n ==-1);           % 110

%%%%%%%%%%%%%%%%%%%%%%% flag31 (Packet is  at second node and both transmitter and receiver has sufficient energy to support the packet) 

G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag31.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==j1-Pr).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));                       % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag31.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==j1-Pr).*(1-Pe2).*(n ==m).*(s ==-1);                  % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag31.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));                % 001
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag31.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);           % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag31.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));         % 011 
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag31.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);    % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag31.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));    % 111
G 	= G 	+ 	rho1*rho2*rho3.*flag31.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1); % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag31.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));           % 110 
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag31.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr).*(1-Pe2).*(n ==m).*(s ==-1);      % 110  
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag31.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));           % 101
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag31.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);      % 101
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag31.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==j1-Pr).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));                  % 100  
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag31.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(m+2)).*(j2==j1-Pr).*(1-Pe2).*(n ==m).*(s ==-1);             % 100
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag31.*(h2==h1).*(i2==i1+1-Lvec2(r+3)).*(j2==j1-Pr).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));                           % 010
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag31.*(h2==h1).*(i2==i1+1-Lvec2(r+3)).*(j2==j1-Pr).*(1-Pe2).*(n ==m).*(s ==-1);                      % 010

%%%%%%%%%%%%%%%%%%%%%%% flag311 (Packet is  at second node and both transmitter and receiver has sufficient energy to support the packet) 

G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag311.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==j1-Pr);                       % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag311.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3));                % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag311.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));         % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag311.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));    % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag311.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr);           % 110
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag311.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3));           % 101
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag311.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==j1-Pr);                  % 100  
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag311.*(h2==h1).*(i2==i1+1-Lvec2(r+3)).*(j2==j1-Pr);                           % 010


%%%%%%%%%%%%%%%%%%%%%%%%%% flag32 (SubCase 32)    % Transmitter has sufficient charge
%%%%%%%%%%%% while receiver require one more unit of energy

G 	= G 	+ 	rho1*rho2*(1-rho3).*flag32.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==j1).*(n ==m).*(s ==r);                              % 110
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag32.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1).*(n ==m).*(s ==r);                                     % 100
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag32.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1).*(n ==m).*(s ==r);                                     % 010
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag32.*(h2==h1).*(i2==i1).*(j2==j1).*(n ==m).*(s ==r);                                          % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag32.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n == m).*(s ==min(r+1,K2-1));               % 001
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag32.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n == m).*(s ==-1);          % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag32.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));         % 011
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag32.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);    % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag32.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));    % 111
G 	= G 	+ 	rho1*rho2*rho3.*flag32.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1); % 111 
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag32.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));           % 101    
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag32.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);      % 101

%%%%%%%%%%%%%%%%%%%%%%%%%% flag321 (SubCase 321)    % Transmitter has sufficient charge
%%%%%%%%%%%% while receiver require one more unit of energy

G 	= G 	+ 	rho1*rho2*(1-rho3).*flag321.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==j1);                              % 110
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag321.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1);                                     % 100
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag321.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1);                                     % 010
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag321.*(h2==h1).*(i2==i1).*(j2==j1);                                          % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag321.*(h2==h1).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3));                             % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag321.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));                       % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag321.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));                  % 111 
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag321.*(h2==min(h1+1,BT1)).*(i2==i1-Lvec2(r+3)).*(j2==min(j1+1-Pr,BT3));                         % 101    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% flag33 (subcase 33)  % Receiver has
%%%%%%%% sufficient energy but transmiiter need one more unit of energy
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag33.*(h2==h1).*(i2==i1).*(j2==j1).*(n ==m).*(s ==r);                                              % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag33.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m).*(s ==r);                                       % 001
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag33.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m).*(s ==r);                                  % 101
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag33.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1).*(n ==m).*(s ==r);                                         % 100  
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag33.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));             % 011
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag33.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);        % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag33.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));        % 111
G 	= G 	+ 	rho1*rho2*rho3.*flag33.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);   % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag33.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));               % 110   
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag33.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr).*(1-Pe2).*(n ==m).*(s ==-1);          % 110
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag33.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));                      % 010
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag33.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr).*(1-Pe2).*(n ==m).*(s ==-1);                 % 010

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% flag331 (subcase 331)  % Receiver has
%%%%%%%% sufficient energy but transmiiter need one more unit of energy
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag331.*(h2==h1).*(i2==i1).*(j2==j1);                                              % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag331.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3));                                       % 001
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag331.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3));                                  % 101
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag331.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1);                                         % 100  
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag331.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));                   % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag331.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));              % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag331.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr);                     % 110  
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag331.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==j1-Pr);                            % 010



%%%%%%%%%%%%%%%%%%%%%%%%%%%%% flag34 (subcase 34)  % Receiver has
%%%%%%%% sufficient energy but transmiiter need one more unit of energy
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag34.*(h2==h1).*(i2==i1).*(j2==j1).*(n ==m).*(s ==r);                                           % 000   
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag34.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m).*(s ==r);                                    % 001
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag34.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3)).*(n ==m).*(s ==r);                               % 101   
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag34.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1).*(n ==m).*(s ==r);                                      % 100
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag34.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==j1).*(n ==m).*(s ==r);                               % 110 
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag34.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1).*(n ==m).*(s ==r);                                      % 010
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag34.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));          % 011
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag34.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);     % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag34.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*Pe2.*(n ==m).*(s ==min(r+1,K2-1));     % 111
G 	= G 	+ 	rho1*rho2*rho3.*flag34.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3)).*(1-Pe2).*(n ==m).*(s ==-1);% 111
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% flag341 (subcase 34)  % Receiver has
%%%%%%%% sufficient energy but transmiiter need one more unit of energy
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag341.*(h2==h1).*(i2==i1).*(j2==j1);                                           % 000   
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag341.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3));                                    % 001
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag341.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3));                               % 101   
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag341.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1);                                      % 100
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag341.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==j1);                               % 110 
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag341.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1);                                      % 010
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag341.*(h2==h1).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));               % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag341.*(h2==min(h1+1,BT1)).*(i2==min(i1+1-Lvec2(r+3),BT2)).*(j2==min(j1+1-Pr,BT3));          % 111

% %%%%%%%%%%%%%%% flag 5 (case 3)
% G 	= G 	+ 	(1 - rho1)*(1-rho2).*flag5.*(i2==i1).*(j2==j1).*(s ==r);   % Battery is zero and energy is not harvested.
% G 	= G 	+ 	(1 - rho2)*rho1.*flag5.*(i2==min(i1+1,BT2)).*(j2==j1).*(s ==r);
% G 	= G 	+ 	(rho1*rho2).*(1-Pe).*flag5.*(i2==min(i1+1-(Lvec2(r+3)),BT2)).*(j2==min(j1+1-Pr,BT3)).*(s==-1); % Battery is zero and energy is harvested and after transmission ACK is received
% G 	= G 	+ 	(rho1*rho2) * Pe.*flag5.*(i2==min(i1+1-(Lvec2(r+3)),BT2)).*(j2==min(j1+1-Pr,BT3)).*(s==min(r+1,(K-1))); % Battery is zero and energy is harvested and after transmission NACK is received
% G 	= G 	+ 	(rho2)*(1-rho1) * Pe.*flag5.*(i2==(i1-(Lvec2(r+3)))).*(j2==j1+1-Pr).*(s==min(r+1,(K-1)));
% G 	= G 	+ 	(rho2)*(1-rho1) *(1- Pe).*flag5.*(i2==(i1-(Lvec2(r+3)))).*(j2==j1+1-Pr).*(s==-1);
% %%%%%%%%%%%%%%% flag 6 (case 4)
% G 	= G 	+ 	(1 - rho1)*(1-rho2).*flag6.*(i2==i1).*(j2==j1).*(s ==r);   % Battery is zero and energy is not harvested.
% G 	= G 	+ 	(1 - rho2)*rho1.*flag6.*(i2==min(i1+1,BT2)).*(j2==j1).*(s ==r);
% G 	= G 	+ 	(rho2)*(1-rho1).*Pe.*flag6.*(i2==i1).*(j2==j1+1).*(s ==r);
% G 	= G 	+ 	(rho1*rho2).*(1-Pe).*flag6.*(i2==(i1+1-(Lvec2(r+3)))).*(j2==j1+1-Pr).*(s==-1); % Battery is zero and energy is harvested and after transmission ACK is received
% G 	= G 	+ 	(rho1*rho2).*Pe.*flag6.*(i2==(i1+1-(Lvec2(r+3)))).*(j2==j1+1-Pr).*(s==min(r+1,(K-1))); % Battery is zero and energy is harvested and after transmission NACK is received
%%%%%%%%%%%%%%% flag 5 (case 5)
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag5.*(h2==h1).*(i2==i1).*(j2==j1);                                       % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag5.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3));                                % 001
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag5.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==min(j1+1,BT3));                         % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag5.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==min(j1+1,BT3));                    % 111
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag5.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==j1);                           % 110
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag5.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3));                           % 101   
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag5.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1);                                  % 100  
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag5.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1);                                  % 010  
%%%%%%%%%%%%%%% flag 6 (case 6)
G 	= G 	+ 	(1 - rho1)*(1-rho2)*(1-rho3).*flag6.*(h2==h1).*(i2==i1).*(j2==j1);                                       % 000
G 	= G 	+ 	(1 - rho1)*(1-rho2)*rho3.*flag6.*(h2==h1).*(i2==i1).*(j2==min(j1+1,BT3));                                % 001 
G 	= G 	+ 	(1 - rho1)*rho2*rho3.*flag6.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==min(j1+1,BT3));                         % 011
G 	= G 	+ 	rho1*rho2*rho3.*flag6.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==min(j1+1,BT3));                    % 111 
G 	= G 	+ 	rho1*rho2*(1-rho3).*flag6.*(h2==min(h1+1,BT1)).*(i2==min(i1+1,BT2)).*(j2==j1);                           % 110 
G 	= G 	+ 	rho1*(1-rho2)*rho3.*flag6.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==min(j1+1,BT3));                           % 101 
G 	= G 	+ 	rho1*(1-rho2)*(1-rho3).*flag6.*(h2==min(h1+1,BT1)).*(i2==i1).*(j2==j1);                                  % 100 
G 	= G 	+ 	(1-rho1)*rho2*(1-rho3).*flag6.*(h2==h1).*(i2==min(i1+1,BT2)).*(j2==j1);                                  % 010

%G 	= G 	+ 	(rho2)*(1-rho1) *(1- Pe).*flag5.*(i2==(i1-(Lvec2(r+3)))).*(j2==j1+1-Pr).*(s==-1);

% eqn(60) to (65) and (30) have 33 cases corresponding to non-zero probability
% and we have exactly 33 cases.
