%% The code segment below is invoked by uwacRun.m (inline) to plot BER curves
legendStrings = []; %Cell array holding legend string of each plot that was drawn
minBER = 1; %used for setting the y-axis limit

%% 1
if sum(sum(ber_CS_fullFftPilot(1:trial,:,1))) ~= 0
    avgBER = mean(ber_CS_fullFftPilot(1:trial,:),1);
    semilogy(loopVar, avgBER, 'r^-.'), grid on, hold on,
    legendStrings{length(legendStrings)+1} = ['FID (~Berger et al.)'];    
    minBER = min(minBER, min(avgBER));
    
    metavars = [metavars ' BER(Berger)'];
    metaformat = [metaformat ' %3e'];
    metadata = [metadata avgBER(:)];
end

%% 3
if sum(sum(ber_OMP_Stage1_partFftPilot(1:trial,:,1))) ~= 0
    avgBER = mean(ber_OMP_Stage1_partFftPilot(1:trial,:),1);
    semilogy(loopVar, avgBER, 'k>-.'), grid on, hold on,
    legendStrings{length(legendStrings)+1} = ['PID Stage-1, N_{iter}=3 (new)'];
    minBER = min(minBER, min(avgBER));
    
    metavars = [metavars ' BER(OMP-Stage-1)'];
    metaformat = [metaformat ' %3e'];
    metadata = [metadata avgBER(:)];     
end

%% 4
if sum(sum(ber_OMP_Stage2_fullFft(1:trial,:,1))) ~= 0
    avgBER = mean(ber_OMP_Stage2_fullFft(1:trial,:),1);
    semilogy(loopVar, avgBER, 'k<-'), grid on, hold on,
    legendStrings{length(legendStrings)+1} = ['PID Stage-2, N_{iter}=3 (new)'];
    minBER = min(minBER, min(avgBER));
    
    metavars = [metavars ' BER(OMP-Stage-2)'];
    metaformat = [metaformat ' %3e'];
    metadata = [metadata avgBER(:)];     
end

%% 9
if sum(sum(ber_LS(1:trial,:))) ~= 0
    avgBER=mean(ber_LS(1:trial,:),1);
    semilogy(loopVar, avgBER, 'b*-'), grid on, hold on,
    legendStrings{length(legendStrings)+1} = 'LS';
    minBER = min(minBER, min(avgBER));
    
    metavars = [metavars ' BER(LS)'];
    metaformat = [metaformat ' %3e'];
    metadata = [metadata avgBER(:)];      
end

%% 10
if sum(sum(ber_CSI(1:trial,:))) ~= 0
    avgBER = mean(ber_CSI(1:trial,:),1);
    semilogy(loopVar, avgBER, 'mx-'), grid on, hold on,
    legendStrings{length(legendStrings)+1} = 'CSI';
    minBER = min(minBER, min(avgBER));
    
    metavars = [metavars ' BER(CSI)'];
    metaformat = [metaformat ' %3e'];
    metadata = [metadata avgBER(:)];     
end

xlabel(xAxisLabel), ylabel('BER'), ylim([minBER 1])

if ~isempty(legendStrings) 
    legend(legendStrings); 
end