package com.example.ear;

// http://stackoverflow.com/questions/12603942/is-it-possible-to-generate-a-tone-audio-of-less-than-1-second-long-or-cut-off-p
// 



import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ToggleButton;
import android.app.Activity;

public class Ear extends Activity implements OnClickListener {
	private final int totalDuration = 15; // seconds+
	private final int duration = 1; // seconds
    private final int sampleRate = 8000;
    private final int numSamples = duration * sampleRate;
    private final int totalNumSamples = totalDuration * sampleRate;
    private final double sample[] = new double[numSamples];
    private double freqOfTone = 440; // hz
    private double method = 0;
    // method = 0; implies generate 1 buffer 1s data for 1 freq and loop over totalDuration secs
    // method = 1; implies generate multiple buffers of 1s data for 1 freq; play; repeat
    // method = 2; implies generate 1 buffer; increase f for every sample
    private byte generatedSnd[];

    Handler handler = new Handler();
    
    private AudioTrack audioTrack;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ear);
        
        ToggleButton buttonToggle;
        buttonToggle = (ToggleButton)findViewById(R.id.buttonToggle);                	      
        buttonToggle.setOnClickListener(this);
        
        Button pressButton;
        pressButton = (Button)findViewById(R.id.button1);                	      
        pressButton.setOnClickListener(this);
        
        turnInvisiblePressOnTone();
        
        if(method == 0)
        	generatedSnd = new byte[2 * totalNumSamples];
        else
        	generatedSnd = new byte[2 * numSamples];        	
    }

    @Override
    protected void onResume() {
        super.onResume();
    }
    
    public void onClick(View src) {
    	switch (src.getId()) {
        case R.id.buttonToggle:
        	ToggleButton tB = (ToggleButton) findViewById(R.id.buttonToggle);
        	if(tB.isChecked()) {
        		System.out.println("Starting sound \n");
        		turnVisiblePressOnTone();
        		if(method == 0)
        			playSound();
        		else
        			playRainbowSound(); // chokes main thread
        	}
        	else
        	{
        		System.out.println("Stopping sound \n");
        		turnInvisiblePressOnTone();
        		stopSound();
        	}
        	break;
    	
    	case R.id.button1:
    		System.out.println("Heard button pressed \n");
    		ToggleButton tB1 = (ToggleButton) findViewById(R.id.buttonToggle);
    		turnInvisiblePressOnTone();
    		int head = audioTrack.getPlaybackHeadPosition();
    		freqOfTone = Math.pow(10,1+(((double) (head*1.75))/totalNumSamples));
    		System.out.println("Head position:" + head + " Freq: " + freqOfTone + "\n");
    		setValueToFreq((int)freqOfTone);
    		stopSound();
    		tB1.toggle();
    		break;
    	}
    }

    void genRainbowTone(){
    	// Generate signal from 1Hz to 1000Hz
    	int offset = 0;
    	for (int i=0; i<totalDuration; ++i){
    		freqOfTone = Math.pow(10,1+(((double) (1.75*i))/totalDuration));
    		genTone(offset, freqOfTone);
    		offset = offset + 2*numSamples;
    	}
    }
    
    void genRainbowToneWhole(){
    	int idx = 0;
        for (int i = 0; i < totalNumSamples; ++i) {
        	final double freq = Math.pow(10, 1+(((double) (i*1.75))/totalNumSamples));
        	final double dVal = Math.sin(2 * Math.PI * i / (sampleRate/freq));
            final short val = (short) ((dVal * 32767));
            // in 16 bit wav PCM, first byte is the low order byte
            generatedSnd[idx] = (byte) (val & 0x00ff);
            idx++;
            generatedSnd[idx] = (byte) ((val & 0xff00) >>> 8);
            idx++;
        }    	
    }
    
    void genTone(int offset, double freq){
        // fill out the array
        for (int i = 0; i < numSamples; ++i) {
            sample[i] = Math.sin(2 * Math.PI * i / (sampleRate/freq));
        }

        // convert to 16 bit pcm sound array
        // assumes the sample buffer is normalised.
        int idx = 0;
        for (final double dVal : sample) {
            // scale to maximum amplitude
            final short val = (short) ((dVal * 32767));
            // in 16 bit wav PCM, first byte is the low order byte
            generatedSnd[offset+idx] = (byte) (val & 0x00ff);
            idx++;
            generatedSnd[offset+idx] = (byte) ((val & 0xff00) >>> 8);
            idx++;

        }
    }

    void playSound(){
    	audioTrack = new AudioTrack(AudioManager.STREAM_MUSIC,
                sampleRate, AudioFormat.CHANNEL_OUT_MONO,
                AudioFormat.ENCODING_PCM_16BIT, generatedSnd.length,
                AudioTrack.MODE_STREAM);
    	if(method == 0)
    		genRainbowTone();
    	else
    		genRainbowToneWhole();
        audioTrack.write(generatedSnd, 0, generatedSnd.length);
        audioTrack.play();
//        while(audioTrack.getPlaybackHeadPosition() < generatedSnd.length){
//        	System.out.println("waiting:" + audioTrack.getPlaybackHeadPosition() + " " + generatedSnd.length + "\n");
//        }
    }
    
    void playRainbowSound(){
    	for (int i=0; i<totalDuration; ++i){
    		freqOfTone = Math.pow(10,1+(((double) (i))/15));
	    	audioTrack = new AudioTrack(AudioManager.STREAM_MUSIC,
	                sampleRate, AudioFormat.CHANNEL_OUT_MONO,
	                AudioFormat.ENCODING_PCM_16BIT, generatedSnd.length,
	                AudioTrack.MODE_STREAM);
	    	genTone(0,freqOfTone);
	        audioTrack.write(generatedSnd, 0, generatedSnd.length);
	        audioTrack.play();
	        while(audioTrack.getPlaybackHeadPosition() < generatedSnd.length/2){
	        	System.out.println("waiting:" + audioTrack.getPlaybackHeadPosition() + " " + generatedSnd.length + "\n");
	        }
	        System.out.println("reached end \n");
	        stopSound();
    	}
    }
    
    void stopSound(){
    	audioTrack.flush();
    	audioTrack.stop();
    	audioTrack.release();
    }
    
    void turnVisiblePressOnTone(){
    	Button pressOnToneButton;
        pressOnToneButton = (Button)findViewById(R.id.button1);
        pressOnToneButton.setVisibility(View.VISIBLE);
    }
    
    void turnInvisiblePressOnTone(){
    	Button pressOnToneButton;
        pressOnToneButton = (Button)findViewById(R.id.button1);
        pressOnToneButton.setVisibility(View.INVISIBLE);
    }
    
    void setValueToFreq(int value){
    	Button freqButton;
        freqButton = (Button)findViewById(R.id.button2);
        freqButton.setText("" + value);
    }

    private class ToggleButtonStopper extends AsyncTask {
		@Override
		protected Object doInBackground(Object... params) {
			ToggleButton tB1 = (ToggleButton) findViewById(R.id.buttonToggle);
    		tB1.setChecked(false);
			return null;
		}
	}
}