package com.example.broadcastrx;

import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.app.Activity;
import android.content.Intent;
import android.content.IntentFilter;

public class MainActivity extends Activity implements OnClickListener 
{
	  //	  
	  @Override
	  public void onCreate(Bundle savedInstanceState) {
	      super.onCreate(savedInstanceState);
	      setContentView(R.layout.activity_main);
	      
	      Button broadcastButton;
	      broadcastButton = (Button) findViewById(R.id.broadcastButton);                	      
	      broadcastButton.setOnClickListener(this);
	  }

	/**
	   * Listing 5-12: Registering and unregistering a Broadcast Receiver in code 
	   */
	  private IntentFilter filter = 
	      new IntentFilter(ClickReceiver.NEW_NAME_GRADE);

	  private ClickReceiver receiver = 
	    new ClickReceiver();

	  @Override
	  public synchronized void onResume() {
	    super.onResume();

	    // Register the broadcast receiver.
	    registerReceiver(receiver, filter); 
	  }

	  @Override
	  public synchronized void onPause() {
	    // Unregister the receiver
	    unregisterReceiver(receiver);  

	    super.onPause();
	  }
	  
	  //
	  private void detectedNameGrade(String name, double grade) {
	    Intent intent = new Intent(ClickReceiver.NEW_NAME_GRADE);
	    intent.putExtra(ClickReceiver.EXTRA_NAME, name);
	    intent.putExtra(ClickReceiver.EXTRA_GRADE, grade);

	    sendBroadcast(intent);
	  }

	public void onClick(View arg0) {
		// TODO Auto-generated method stub
		switch (arg0.getId()) 
		{
        case R.id.broadcastButton:
        	String name = ((EditText) findViewById(R.id.nameText)).getText().toString();
        	String grade = ((EditText) findViewById(R.id.gradeText)).getText().toString();
        	detectedNameGrade(name,Double.parseDouble(grade));
        	break;
		}
	}
}
