package com.example.broadcastrxoutsideapp;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Settings;
import android.widget.EditText;
import android.widget.Toast;

public class ClickReceiverOutsideApp extends BroadcastReceiver 
{
	  public final static String EXTRA_NAME = "EXTRA_NAME";
	  public final static String EXTRA_GRADE = "EXTRA_GRADE";

	  public static final String ACTION_NAME_GRADE = "com.dipanjan.action.NAME_GRADE";

	  public static final String NEW_NAME_GRADE = "com.dipanjan.action.NEW_NAME_GRADE";

	  @Override
	  public void onReceive(Context context, Intent intent) {
	    Uri data = intent.getData();
	    String name = intent.getStringExtra(EXTRA_NAME);
	    double grade = intent.getDoubleExtra(EXTRA_GRADE, 0);
	    
	    ContentValues values = new ContentValues();
	    values.put(StudentsProvider.NAME, name);
	    values.put(StudentsProvider.GRADE, Double.toString(grade));
	    Uri uri = context.getContentResolver().insert(StudentsProvider.CONTENT_URI, values);
	  }
}
