package com.example.cpaccess;


import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.app.Activity;
import android.content.ContentProviderClient;
import android.database.Cursor;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;


public class StudentAccess extends Activity implements OnClickListener
{
	private TextView studentList;
	static final String _ID = "_id";
	static final String NAME = "name";
	static final String GRADE = "grade";
    
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_student_access);
        
        studentList = (TextView) findViewById(R.id.studentView);
        
        Button fetchButton;
        fetchButton = (Button) findViewById(R.id.fetchButton);                	      
        fetchButton.setOnClickListener(this);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_student_access, menu);
        return true;
    }

	public void onClick(View arg0) {
		// TODO Auto-generated method stub
		switch (arg0.getId()) 
		{
        case R.id.fetchButton:
        	String URL = "content://com.example.provider.College/students";
            Uri students = Uri.parse(URL);
            ContentProviderClient yourCR = getContentResolver().acquireContentProviderClient(students);       
            Cursor c;
			try {
				c = yourCR.query(students, null, null, null, null);
				if (c.moveToFirst()) {
	                do{
	                   Toast.makeText(this, 
	                   c.getString(c.getColumnIndex(_ID)) + 
	                   ", " +  c.getString(c.getColumnIndex( NAME)) + 
	                   ", " + c.getString(c.getColumnIndex( GRADE)), 
	                   Toast.LENGTH_SHORT).show();
	                } while (c.moveToNext());
	             }
			} catch (RemoteException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
            
            break;
		}
	}
}
