package com.example.lifecycle;

import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity implements OnClickListener {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        Button nextButton;
        nextButton = (Button) findViewById(R.id.s1b);                	      
        nextButton.setOnClickListener(this);
        
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    
    @Override
    public void onPause() {
    	super.onPause();
    	SharedPreferences userDetails = getSharedPreferences("userdetails", MODE_PRIVATE);
    	Editor edit = userDetails.edit();
    	edit.clear();
    	edit.putString("username", ((TextView) findViewById(R.id.s1t)).getText().toString().trim());
    	edit.commit();
    }
    
    @Override
    public void onResume() {
    	super.onResume();
    	SharedPreferences userDetails = getSharedPreferences("userdetails", MODE_PRIVATE);
    	String Uname = userDetails.getString("username", "");
    	((TextView) findViewById(R.id.s1t)).setText(Uname);
    }
    
    

	public void onClick(View arg0) {
		// TODO Auto-generated method stub
		switch (arg0.getId()) 
		{
        case R.id.s1b:
        	Intent i = new Intent(this, secondActivity.class);
            startActivity(i);
        	break;
		}
	}
}
