package com.example.location;

import java.util.List;

import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.provider.Settings;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.ToggleButton;

@TargetApi(9)
public class MainActivity extends Activity implements OnClickListener, LocationListener{

	private LocationManager locationManager;
	private TextView latitudeValue;
	private TextView longitudeValue;
	private TextView providerValue;
	private TextView accuracyValue;
	private TextView TTFFvalue;
	private TextView availableValue;
	private boolean fineAccuracy; 
	private Criteria criteria = new Criteria();
	private long timeAtStart;
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        fineAccuracy = false;
        locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
        latitudeValue = (TextView) findViewById(R.id.latitudeValue);
        longitudeValue = (TextView) findViewById(R.id.longitudeValue);
        providerValue = (TextView) findViewById(R.id.providerValue);
        accuracyValue = (TextView) findViewById(R.id.accuracyValue);
        TTFFvalue = (TextView) findViewById(R.id.TTFFvalue);
        availableValue = (TextView) findViewById(R.id.availableValue);
        
        //Location location = getLocation();
        latitudeValue.setText("NA");
        longitudeValue.setText("NA");
        providerValue.setText("NA");
        accuracyValue.setText("NA");
        TTFFvalue.setText("NA");
        availableValue.setText("NA");
        
        Button initiateButton;
        initiateButton = (Button) findViewById(R.id.InitiateButton);                	      
        initiateButton.setOnClickListener(this);
        
        Button availableButton;
        availableButton = (Button) findViewById(R.id.availableButton);                	      
        availableButton.setOnClickListener(this);
        
        Button settingsButton;
        settingsButton = (Button) findViewById(R.id.settingsButton);                	      
        settingsButton.setOnClickListener(this);
        
        Button GPSbutton;
        GPSbutton = (Button) findViewById(R.id.GPSbutton);                	      
        GPSbutton.setOnClickListener(this);
        
        ToggleButton fineON;
        fineON = (ToggleButton)findViewById(R.id.fineButton);                	      
        fineON.setOnClickListener(this);
        fineON.setText("COARSE");
        
    } 

    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    
//    public Location getLocation() 
//    {
//    	Location locationReturn = null;
//    	// The minimum distance to change Updates in meters
//        final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10; // 10 meters
//        // The minimum time between updates in milliseconds
//        final long MIN_TIME_BW_UPDATES = 1000 * 60 * 1; // 1 minute
//        
//        try 
//        {
//             // getting GPS status
//            final boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
// 
//            // getting network status
//            final boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
// 
//            if (!isGPSEnabled && !isNetworkEnabled) 
//            {
//                // no network provider is enabled
//            } 
//            else 
//            {
//                // First get location from Network Provider
//                if (isNetworkEnabled) 
//                {
////                    locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, MIN_TIME_BW_UPDATES,
////                            MIN_DISTANCE_CHANGE_FOR_UPDATES, this);
////                    Log.d("Network Enabled", "Network Enabled");
////                    if (locationManager != null) 
////                    {
////                        locationReturn = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
////                    }
//                }
//                else
//                {
//                	Log.d("Network Disabled", "Network Disabled");
//                }
//                
//                // if GPS Enabled get lat/long using GPS Services
//                if (isGPSEnabled) 
//                {
//                    if (locationReturn == null) 
//                    {
//                        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, MIN_TIME_BW_UPDATES,
//                                MIN_DISTANCE_CHANGE_FOR_UPDATES, this);
//                        Log.d("GPS Enabled", "GPS Enabled");
//                        if (locationManager != null) 
//                        {
//                            locationReturn = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
//                        }
//                    }
//                }
//                else
//                {
//                	Log.d("GPS Disabled", "GPS Disabled");
//                }
//            }
//        } 
//        catch (Exception e) 
//        {
//            e.printStackTrace();
//        }
// 
//        return locationReturn;
//    }

	public void onLocationChanged(Location location) 
	{
		// TODO Auto-generated method stub
		long timeToFix = SystemClock.uptimeMillis() - timeAtStart;
		
		latitudeValue.setText("" + location.getLatitude());
        longitudeValue.setText(String.valueOf(location.getLongitude()));
        providerValue.setText(String.valueOf(location.getProvider()));
        TTFFvalue.setText(String.valueOf(timeToFix/1000));
        accuracyValue.setText(String.valueOf(location.getAccuracy()));
		locationManager.removeUpdates(this);
	}

	public void onProviderDisabled(String provider) 
	{
		// TODO Auto-generated method stub
		
	}

	public void onProviderEnabled(String provider) 
	{
		// TODO Auto-generated method stub
		
	}

	public void onStatusChanged(String provider, int status, Bundle extras) 
	{
		// TODO Auto-generated method stub
		
	}

	public void onClick(View arg0) 
	{
		// TODO Auto-generated method stub
		switch (arg0.getId()) 
		{
        case R.id.InitiateButton:
        	latitudeValue.setText("0.0");
            longitudeValue.setText("0.0");
            providerValue.setText("0.0");
            TTFFvalue.setText("0.0");
            availableValue.setText("0.0");
            accuracyValue.setText("0.0");
            break;
        
        case R.id.settingsButton:
        	startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
            break;
            
        case R.id.GPSbutton:
        	timeAtStart = SystemClock.uptimeMillis();
        	locationManager.requestSingleUpdate(criteria, this, null);        	        	
            break;
            
        case R.id.fineButton:
        	ToggleButton fB = (ToggleButton) findViewById(R.id.fineButton);
        	if(fB.isChecked()) 
        	{
        		Log.d("Fine Accuracy", "Fine Accuracy");
        		fineAccuracy = true;
        		fB.setText("FINE");
        	}
        	else 
        	{
        		Log.d("Coarse Accuracy", "Coarse Accuracy");
        		fineAccuracy = false;
        		fB.setText("COARSE");
        	}
        	break;
          
        case R.id.availableButton:
        	StringBuffer stringBuffer = new StringBuffer();
        	if(fineAccuracy)
        		criteria.setAccuracy(Criteria.ACCURACY_FINE);
        	else
        		criteria.setAccuracy(Criteria.ACCURACY_COARSE);
        	List<String> enabledProviders = locationManager.getProviders(criteria, true);
        	if(enabledProviders.isEmpty())
        	{
        		availableValue.setText("None");
        	}
        	else
        	{
        		for (String enabledProvider : enabledProviders)
        		{
        			stringBuffer.append(enabledProvider).append(" ");
        		}
        		availableValue.setText(stringBuffer);
        	}
        	break;
        	
        }		
	}
}
