package com.example.physicalsensors;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.hardware.Sensor;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class DefaultSensor extends Activity implements OnClickListener
{
	private SensorApplication app;
	Sensor defaultSensor;

	public void onCreate(Bundle savedInstanceState) 
	{
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_default_sensor);
        app = (SensorApplication) getApplication();
        
    	Button defaultButton;
        defaultButton = (Button) findViewById(R.id.sensorNameButton);                	      
        defaultButton.setOnClickListener(this);

    	Button registerButton;
    	registerButton = (Button) findViewById(R.id.registerButton);                	      
    	registerButton.setOnClickListener(this);

        defaultSensor = app.getSensorManager().getDefaultSensor(app.getMySensor());
        defaultButton.setText(defaultSensor.getName());
	}

	@TargetApi(9)
	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch (v.getId()) 
		{
        case R.id.sensorNameButton:
        	TextView maxRange = (TextView) findViewById(R.id.maxRange);
        	maxRange.setText(""+defaultSensor.getMaximumRange());
        	TextView minDelay = (TextView) findViewById(R.id.minDelay);
        	minDelay.setText(""+defaultSensor.getMinDelay());
        	TextView name = (TextView) findViewById(R.id.name);
        	name.setText(""+defaultSensor.getName());
        	TextView power = (TextView) findViewById(R.id.power);
        	power.setText(""+defaultSensor.getPower());
        	TextView resolution = (TextView) findViewById(R.id.resolution);
        	resolution.setText(""+defaultSensor.getResolution());
        	TextView type = (TextView) findViewById(R.id.type);
        	type.setText(""+defaultSensor.getType());
        	TextView vendor = (TextView) findViewById(R.id.vendor);
        	vendor.setText(""+defaultSensor.getVendor());
        	TextView version = (TextView) findViewById(R.id.version);
        	version.setText(""+defaultSensor.getVersion());
            break;
        case R.id.registerButton:
        	Intent i = new Intent(this, SensorValues.class);
            startActivity(i);
        	break;
		}
	}
}
