package com.example.physicalsensors;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class EarthAxis extends Activity implements OnClickListener
{
	private SensorApplication app;
	
	private float x = 0;
	private float y = 0;
	private float z = 0;
	private float xE = 0;
	private float yE = 0;
	private float zE = 0;
	private float[] Hfield = new float[3];
	private float[] acceleration = new float[3];
	private Timer updateTimer;

	public void onCreate(Bundle savedInstanceState) 
	{
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_earth_axis);
        app = (SensorApplication) getApplication();
        
        Button startButton;
        startButton = (Button) findViewById(R.id.startEarthButton);                	      
        startButton.setOnClickListener(this);
        
        Button stopButton;
        stopButton = (Button) findViewById(R.id.stopEarthButton);                	      
        stopButton.setOnClickListener(this);
        
        updateTimer = new Timer("bUpdate");
	    updateTimer.scheduleAtFixedRate(new TimerTask() {
	    	public void run() {
	    		updateGUI();
	    	}
	    }, 0, 100);
	}
	
	private final SensorEventListener mySensorListener = new SensorEventListener() 
	{
	    public void onAccuracyChanged(Sensor sensor, int accuracy) 
	    {
	    	;
	    }

	    public void onSensorChanged(SensorEvent event) 
	    {
	    	switch(event.sensor.getType())
	    	{
	    	case Sensor.TYPE_ACCELEROMETER:
		    	x = event.values[0];
		    	y = event.values[1];
		    	z = event.values[2];
		    	acceleration = event.values.clone();
	    		break;
	    	case Sensor.TYPE_MAGNETIC_FIELD:
	    		Hfield = event.values.clone();
	    		break;	    		
	    	}
	    	
	    	 final int matrix_size = 16; 
	         float[] R = new float[matrix_size]; 
	         float[] outR = new float[matrix_size]; 
	         float[] I = new float[matrix_size]; 

	         if (Hfield != null && acceleration != null) 
	         { 
	        	 SensorManager.getRotationMatrix(R, I, acceleration, Hfield); 
	             //SensorManager.remapCoordinateSystem(R, SensorManager.AXIS_Y, SensorManager.AXIS_MINUS_X, outR); 
	             //SensorManager.getOrientation(R, values); 
	         }
	         
	         xE = R[0]*acceleration[0]+R[1]*acceleration[1]+R[2]*acceleration[2];
	         yE = R[4]*acceleration[0]+R[5]*acceleration[1]+R[6]*acceleration[2];
	         zE = R[8]*acceleration[0]+R[9]*acceleration[1]+R[10]*acceleration[2];
	    }
	};

	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch (v.getId()) 
		{
			case R.id.startEarthButton:
				app.getSensorManager().registerListener(mySensorListener, app.getSensorManager().getDefaultSensor(app.getMySensor()), SensorManager.SENSOR_DELAY_UI);
				app.getSensorManager().registerListener(mySensorListener, app.getSensorManager().getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD), SensorManager.SENSOR_DELAY_UI);
				break;
				
			case R.id.stopEarthButton:
				app.getSensorManager().unregisterListener(mySensorListener, app.getSensorManager().getDefaultSensor(app.getMySensor()));
				app.getSensorManager().unregisterListener(mySensorListener, app.getSensorManager().getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD));
				break;
		}
	}
	
	private void updateGUI() {
		runOnUiThread(new Runnable() {
			public void run() {
				String sX = String.format("%.2f", x);
				TextView p1 = (TextView)findViewById(R.id.xDeviceValue);
				p1.setText(sX);

				String sY = String.format("%.2f", y);;
				TextView p2 = (TextView)findViewById(R.id.yDeviceValue);
				p2.setText(sY);
				
				String sZ = String.format("%.2f", z);;
				TextView p3 = (TextView)findViewById(R.id.zDeviceValue);
				p3.setText(sZ);				
				
				String sXE = String.format("%.2f", xE);
				TextView p1E = (TextView)findViewById(R.id.xEarthValue);
				p1E.setText(sXE);

				String sYE = String.format("%.2f", yE);;
				TextView p2E = (TextView)findViewById(R.id.yEarthValue);
				p2E.setText(sYE);
				
				String sZE = String.format("%.2f", zE);;
				TextView p3E = (TextView)findViewById(R.id.zEarthValue);
				p3E.setText(sZE);				

			}
		});
	};
};
