package com.example.physicalsensors;

import java.util.ArrayList;
import java.util.List;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.TextView;
import android.widget.Toast;

public class PhysicalSensors extends Activity implements OnClickListener
{
	private TextView mySensorText;
	private SensorApplication app;

    @Override
    public void onCreate(Bundle savedInstanceState) 
    {    	
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_physical_sensors);
        app = (SensorApplication) getApplication();
        RadioGroup radioGroup = (RadioGroup) findViewById(R.id.SensorPicker);
        mySensorText = (TextView) findViewById(R.id.SensorChoice);
        ListView availableList = (ListView) findViewById(R.id.availableList);
        
        String[] values = new String[] { "None"};
        final ArrayAdapter adapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, values);
        availableList.setAdapter(adapter);
                
        Button availableButton;
        availableButton = (Button) findViewById(R.id.availibilityButton);                	      
        availableButton.setOnClickListener(this);
        
        Button defaultButton;
        defaultButton = (Button) findViewById(R.id.defaultSensorButton);                	      
        defaultButton.setOnClickListener(this);
        
        radioGroup.setOnCheckedChangeListener(new OnCheckedChangeListener() 
        {
			public void onCheckedChanged(RadioGroup group, int checkedId) 
			{
				// TODO Auto-generated method stub
				if(checkedId == R.id.accelerometerButton) 
				{
					app.setMySensor(Sensor.TYPE_ACCELEROMETER);
					mySensorText.setText("Sensor: ACCELEROMETER");
					Toast.makeText(getApplicationContext(), "choice: Accelerometer", Toast.LENGTH_SHORT).show();
				}
				else if(checkedId == R.id.gyroscopeButton) 
				{
					app.setMySensor(Sensor.TYPE_GYROSCOPE);
					mySensorText.setText("Sensor: GYROSCOPE");
					Toast.makeText(getApplicationContext(), "choice: Gyroscope", Toast.LENGTH_SHORT).show();
				}
				else if(checkedId == R.id.magneticFieldButton) 
				{
					app.setMySensor(Sensor.TYPE_MAGNETIC_FIELD);
					mySensorText.setText("Sensor: MAGNETIC_FIELD");
					Toast.makeText(getApplicationContext(), "choice: Magnetic Field", Toast.LENGTH_SHORT).show();
				}
				else if(checkedId == R.id.allButton) 
				{
					app.setMySensor(Sensor.TYPE_ALL);
					mySensorText.setText("Sensor: ALL");
					Toast.makeText(getApplicationContext(), "choice: All", Toast.LENGTH_SHORT).show();
				}
			}
        });
        
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_physical_sensors, menu);
        return true;
    }

	public void onClick(View arg0) {
		// TODO Auto-generated method stub
		switch (arg0.getId()) 
		{
        case R.id.availibilityButton:
        	List<Sensor> sensors = app.getSensorManager().getSensorList(app.getMySensor());
        	List<String> listSensorType = new ArrayList<String>();
            for(int i=0; i<sensors.size(); i++)
            {
            	listSensorType.add(sensors.get(i).getName());
            }
            ListView availableList = (ListView) findViewById(R.id.availableList);
            final ArrayAdapter adapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, listSensorType);
            availableList.setAdapter(adapter);
            break;
            
        case R.id.defaultSensorButton:
            Intent i = new Intent(this, DefaultSensor.class);
            startActivity(i);
            break;
		}
	}
}
