package com.example.physicalsensors;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class SensorValues extends Activity implements OnClickListener
{
	private SensorApplication app;
	Sensor defaultSensor;
	
	private float x = 0;
	private float y = 0;
	private float z = 0;
	private Timer updateTimer;

	public void onCreate(Bundle savedInstanceState) 
	{
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_sensor_values);
        app = (SensorApplication) getApplication();
        
        Button startButton;
        startButton = (Button) findViewById(R.id.startButton);                	      
        startButton.setOnClickListener(this);
        
        Button stopButton;
        stopButton = (Button) findViewById(R.id.stopButton);                	      
        stopButton.setOnClickListener(this);
        
        Button earthAxisButton;
        earthAxisButton = (Button) findViewById(R.id.earthAxisButton);                	      
        earthAxisButton.setOnClickListener(this);
        
        updateTimer = new Timer("aUpdate");
	    updateTimer.scheduleAtFixedRate(new TimerTask() {
	    	public void run() {
	    		updateGUI();
	    	}
	    }, 0, 100);
	}
	
	private final SensorEventListener mySensorListener = new SensorEventListener() 
	{
	    public void onAccuracyChanged(Sensor sensor, int accuracy) 
	    {
	    	;
	    }

	    public void onSensorChanged(SensorEvent event) 
	    {
	    	switch(event.sensor.getType())
	    	{
	    	case Sensor.TYPE_ACCELEROMETER:
		    	x = event.values[0];
		    	y = event.values[1];
		    	z = event.values[2];
	    		break;
	    	}
	    }
	};

	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch (v.getId()) 
		{
			case R.id.startButton:
				app.getSensorManager().registerListener(mySensorListener, app.getSensorManager().getDefaultSensor(app.getMySensor()), SensorManager.SENSOR_DELAY_UI);
				break;
				
			case R.id.stopButton:
				app.getSensorManager().unregisterListener(mySensorListener, app.getSensorManager().getDefaultSensor(app.getMySensor()));
				break;
			case R.id.earthAxisButton:
				Intent i = new Intent(this, EarthAxis.class);
	            startActivity(i);
				break;
		}
	}
	
	private void updateGUI() {
		runOnUiThread(new Runnable() {
			public void run() {
				String sX = String.format("%.2f", x);
				TextView p1 = (TextView)findViewById(R.id.xValueText);
				p1.setText(sX);

				String sY = String.format("%.2f", y);;
				TextView p2 = (TextView)findViewById(R.id.yValueText);
				p2.setText(sY);
				
				String sZ = String.format("%.2f", z);;
				TextView p3 = (TextView)findViewById(R.id.zValueText);
				p3.setText(sZ);				
			}
		});
	};
};
