function surr = surround(candidate_set, selected_set,r,FC,rgg)
% This function is to test whether the selected set is surrounded by the
% candidate set. If yes, it tells no new sensors can be added to the
% candidate set next, and the greedy algorithm converges. If no, it tells
% more iterations required still.

% r: receiver locations
% rgg: transmission range
% old_set: [FC, index of avaibable mics] with 0 denoting the FC


[~,M] = size(r); % M: number of total sensors
N = length(selected_set);
new_set = [];
if N == 0
    for i = 1:M
        if norm(r(:,i)-FC) <= rgg
            new_set = [new_set;i];
        end
    end
else
    for j = 1:N
        for i = 1:M
            if norm(r(:,i)-FC) <= rgg || norm(r(:,i)-r(:,selected_set(j))) <= rgg
                new_set = [new_set;i];
            end
        end
    end
end
new_set = unique(new_set); 
surr = all(ismember(new_set, candidate_set));
    