
function [F] = FmPassive(sn,am,options)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: S.P. Chepuri and G. Leus. Sparsity-Promoting Sensor Selection 
%        for Non-linear Measurement Models. IEEE Trans. on Signal 
%        Processing, 63(3): 684-698, Feb. 2015.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: Sep 2013
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
% Fisher information matrix
% for ToA based Localization
% Sundeep Prabhakar, TU Delft, Aug 2012
% For Anchor placement
%
% output- F lxl Fisher information matrix
% Input-  svec : lx 1 sensor position
%         svec : lx 1 anchor position
%          v   : speed of propogation
%        sigma2: variance on time-delay measurements
%%%%%%%%%%%%%%%%%%%%%%%%%

if ~isfield(options,'MeasurementType')
    options.MeasurementType = 'RangeBearing';
end

d = norm(sn-am,2);
P = [0 1; -1 0];   % pi/2 rotation matrix

beta  = 2; % path-loss (free-space)
% alpha = 1; % path-gain
% c = 3*10^8; % speed of light [m/s]
% N0 = 1e-5; % w/Hz; case1
% omega2 = (8*10^9*2*pi)^2; % [GHz]
% es=1e-5;
% sigma2 = c^2*(N0/2)./(alpha*d.^-beta*omega2*es);

sigma2range = 1.78*10^-5/(d.^-beta);
sigma2bearing = 2*10^-5; % rad^2 %10^-4 RangeBearing, 
sigma2pathloss = 1; %dB

Fbearing = (1/sigma2bearing)* (P*(am-sn)*(am-sn)'*P')./d^4 ;
Frange = (sn-am)*(sn-am).'/(sigma2range*d^2);

switch lower(options.MeasurementType)
    case {lower('Range')}
        %Frange = (1/sigma2range)*((sn-am)*(sn-am)'./d^2); % FIM of the range
        F =Frange;
    case {lower('RangeBearing')}
        F = Frange + Fbearing;
    case {lower('Bearing')}
        F = Fbearing;
    case {lower('pathloss')}
             F = (1/sigma2pathloss)*(50*beta^2/(d^4*log(10))) * (sn-am)*(sn-am).';    
    case {lower('RSS')}
        %sigma2rss = 10^-7/(d.^-beta); 
        
        sigma2rss = 10^-5; 
        gain = 1;
        F = (1/sigma2rss)*((4*gain^2)/(gain+d^2)^2) * (sn-am)*(sn-am).';
        
        
end

end

