%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: Sparse Sensing for Distributed Detection. IEEE Trans. on Signal 
%        Processing, 16(6): 1446-1460, Mar. 2016.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: March 2015
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all;
clc; close all;
M=15;
sigma = 1;
f=0.33;
theta1 = cos(2*pi*f.*[1:M]');
theta0 = zeros(M,1);

priorvec = 0.3; alpha = 0.1;


pi0 = priorvec; pi1 = 1 - pi0;
thr = log(pi0/pi1);



%% NP
Dklvec = (theta1-theta0).^2/(2*sigma^2);
Dsum = sum(Dklvec);
[valu, idx] = sort(Dklvec,'descend');


lambda = [0.1:0.1:0.9];% 0.9999];

for ll = 1: length(lambda)
    
    w_explicit=zeros(M,1);
    daux=0;
    for mm=1:M
        
        if (daux <lambda(ll)*Dsum)
            daux = daux + valu(mm);
        else
            mm =mm-1;
            break;
        end
    end
    if (daux >= lambda(ll)*Dsum)
        daux = daux - valu(mm);
        mm=mm-1;
    end
    
    w_explicit(idx(1:mm),1)=1;
    w_explicit(idx(mm+1),1)= ((lambda(ll)*Dsum - daux)/valu(mm+1) >0);
    wsel_idx_NP = find(w_explicit ==1 );
    
    K_NP(ll) = nnz(wsel_idx_NP);
    
    
    m1 = theta1(wsel_idx_NP);
    m0 = theta0(wsel_idx_NP);
    
    d2 = (m1-m0)'*(m1-m0)/sigma^2;
    
    d=sqrt(d2);
    
    thr_classical = d*qfuncinv(alpha) - d2/2;
    Pmd(ll) = 1-qfunc(thr_classical/d - d2/(2*d));
    
    
    
end

figure(1);
set(gca,'Fontsize', 16);
h1=semilogy(lambda*Dsum, Pmd,'--sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Classical setting');
for ii=1:9
labels = num2str(K_NP(ii),'%d');   labels = strcat('K=',labels);
text(lambda(ii)*Dsum, Pmd(ii)+0.01, labels, 'horizontal','left', 'vertical','bottom')
end
xlabel('KLdistance');  ylabel('pmd');
grid on;
hleg2= legend([h1], 'Classical setting (\alpha = 0.01)',...
    'Location','Best'); 
set(hleg2,'FontSize',16); xlim([0 4])
set(gca,'Layer','top'); 
 print('-deps', 'solutionpathNP.eps');


%%
%B-distance
Bvec = (theta1-theta0).^2/(8*sigma^2);
Bsum = sum(Bvec);

[valu, idx] = sort(Bvec,'descend');
for ll = 1: length(lambda)
    
    w_explicit=zeros(M,1);
    daux=0;
    for mm=1:M
        
        if (daux <lambda(ll)*Bsum)
            daux = daux + valu(mm);
        else
            mm =mm-1;
            break;
        end
    end
    if (daux >= lambda(ll)*Bsum)
        daux = daux - valu(mm);
        mm=mm-1;
    end
    
    w_explicit(idx(1:mm),1)=1;
    w_explicit(idx(mm+1),1)= ((lambda(ll)*Dsum - daux)/valu(mm+1) >0);
    wsel_idx_Bay = find(w_explicit ==1 );
    
    K_Bay(ll) = nnz(wsel_idx_Bay);
    
    
    m1 = theta1(wsel_idx_Bay);
    m0 = theta0(wsel_idx_Bay);
    
    d2 = (m1-m0)'*(m1-m0)/sigma^2;
    
    d=sqrt(d2);
    Pm = 1 - qfunc(thr/d - d2/(2*d));
    Pfa = qfunc(thr/d + d2/(2*d));
    Pe(ll) = pi1 * Pm + pi0*Pfa;
    
end
%%
close all;
figure(2);
set(gca,'Fontsize', 16);
h2=semilogy(lambda*Bsum, Pe,'-+k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Bayesian setting');
for ii=1:9
labels = num2str(K_NP(ii),'%d');   labels = strcat('K=',labels);
text(lambda(ii)*Bsum, Pe(ii), labels, 'horizontal','left', 'vertical','bottom')
end
xlabel('Bdistance');  ylabel('pe');
grid on;
hleg2= legend([h2],'Bayesian setting (pi0 = 0.3)AAA',...
    'Location','Best');
set(hleg2,'FontSize',16)
set(gca,'Layer','top');

print('-deps', 'solutionpathBay.eps');


