%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Paper: Sparse Sensing for Distributed Detection. IEEE Trans. on Signal 
%        Processing, 16(6): 1446-1460, Mar. 2016.
% Author: Sundeep Prabhakar Chepuri, TU Delft
% Date: March 2015
%
% 
%
% Needs CVX toolbox
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all;
clc; close all;

M=15;
sigma = 1;
f=0.33;
theta1 = cos(2*pi*f.*[1:M]');
theta0 = zeros(M,1);

cvx_quiet(true);
K= 5:1:14;
priorvec = 0.3; alpha = 0.01;
MKR = {'k', '+k'};
ind = 1;
rhovec = [0.25, 0.75];

Bayes_opt = zeros(length(K),2);
Bayes_cvx=zeros(length(K),2);
NP_opt=zeros(length(K),2);
NP_cvx=zeros(length(K),2);
Be = zeros(length(K),2,2);
Bd = zeros(length(K),2,2);
Phi = eye(M); 
for rr=1:length(rhovec)
    
    
    rho = rhovec(rr);
    
%     Sigma = (1 -rho) * eye(M) + rho* ones(M,M);
    %     a = 1/(1-rho); b = (-rho/(1-rho))*(1/(1 + (M-1)*rho));
    %     Sigmainv = a * eye(M) + b*ones(M,M);
    
    
    Sigma = toeplitz(rho.^(0:M-1)) ;
    
    SS = Sigma - 0.11*eye(M);
    ainv = 1/0.11; SSinv = inv(SS);
    
    mm_vec = SSinv*(theta1-theta0);
    
    pi0 = priorvec;
    pi1 = 1 - pi0;
    
    thr = log(pi0/pi1);
    
    for k = 1:length(K)
        
        temp_comb = nchoosek(1:M,K(k));
        
        Pe = zeros(length(temp_comb),1);  Pmd= zeros(length(temp_comb),1);
        
        for ii=1:length(temp_comb)
            
            select=temp_comb(ii,:);
            
            Phi_r=Phi(sort(select),:);
            mvec = (Phi_r*(theta1- theta0));
            
            %snr
            d2 = mvec'*inv(0.11*eye(K(k)) + Phi_r*SS*Phi_r')*mvec; 
            
           
            d=sqrt(d2);
 
            Pm = 1 - qfunc(thr/d - d2/(2*d));
            Pfa = qfunc(thr/d + d2/(2*d));
            Pe(ii) = pi1 * Pm + pi0*Pfa;
            
            thr_classical = d*qfuncinv(alpha) - d2/2;
            Pmd(ii) = 1-qfunc(thr_classical/d - d2/(2*d));
                        
            
        end
        [Pe_opt(k), idx_aux(k)] = min(Pe);
        [Pd_opt(k), idx_aux2(k)] = min(Pmd);
        
        [Pe_worst(k), idx_aux11(k)] = max(Pe);
        [Pd_worst(k), idx_aux22(k)] = max(Pmd);
        
        
        cvx_solver sedumi
        cvx_begin sdp
        variable w(M)
        variable t
        minimize t
        subject to
        sum(w) ==  K(k);
        [SSinv + ainv*diag(w), mm_vec;
            mm_vec' , t] >= semidefinite(M+1);
        w(:)<=1;
        w(:)>=0;
        cvx_end
        
        %deterministic rounding
%            wsort=sort(w); thres=wsort(M-K(k));
%            wsel_idx = find(w >thres);
%            wsel_idx = wsel_idx(1:K(k));
        
        %randomized rounding
        [wsel] = randomized_rounding_toeplitz(w,SS,K(k),theta1-theta0);
        wsel_idx = find(wsel == 1);
        %
        % Pd of SigmaigmaenSigmaigmael
        
        Phi_r=Phi(sort(wsel_idx),:);
        mvec1 = (Phi_r*(theta1- theta0));
            
        %snr
        d2 = mvec1'*inv(0.11*eye(K(k)) + Phi_r*SS*Phi_r')*mvec1; 
        d=sqrt(d2);
        
        Pm = 1 - qfunc(thr/d - d2/(2*d));
        Pfa = qfunc(thr/d + d2/(2*d));
        Pe_SigmaigmaenSigmaigmael(k) = pi1 * Pm + pi0*Pfa;
        
        
        thr_classical = d*qfuncinv(alpha) - d2/2;
        Pd_Sigmaigmaensel(k) = 1- qfunc(thr_classical/d - d2/(2*d));
        
    end
    
    Bayes_opt(:,ind) = Pe_opt;
    Bayes_cvx(:,ind) = Pe_SigmaigmaenSigmaigmael;
    NP_opt(:,ind) = Pd_opt;
    NP_cvx(:,ind) = Pd_Sigmaigmaensel;
    
    Be(:,:,ind) = [Pe_opt', Pe_worst'-Pe_opt'];
    Bd(:,:,ind) = [Pd_opt', Pd_worst'-Pd_opt'];
    
    ind = ind +1;
end
%%
close all

%rho = 0.1

%rho = 0.75
figure(1);

set(gca,'Fontsize', 16);
area(Be(:,:,1),'FaceColor',[0.6 0.6 0.6], 'LineStyle','none');
set(gca,'XLim',[1 10])
set(gca,'XTick',[1:10])
set(gca,'XTickLabel',5:14); set (gca, 'Yscale', 'log');
hold on;

h1=semilogy(Bayes_opt(:,1),'k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Bayes optimal (brute force)');
hold on;
h2=semilogy(Bayes_cvx(:,1),'-sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

%ylim([10^-4 10]);
hleg2= legend([h1,h2],'Bayes optimal (pi0 = 0.3)','Bayes relaxed, randomized (pi0 = 0.3)AAAA',...
    'Location','Northoutside');
set(hleg2,'FontSize',16);

set(gca,'Layer','top');
xlabel('k');  ylabel('pe');
%legend boxoff;
print('-deps', 'rho0p25Bay.eps');



figure(2);
set(gca,'Fontsize', 16);
area(Bd(:,:,1),'FaceColor',[0.8 0.8 0.8], 'LineStyle','none');
set(gca,'XLim',[1 10])
set(gca,'XTick',[1:10])
set(gca,'XTickLabel',5:14); set (gca, 'Yscale', 'log');
hold on;


h3=semilogy(NP_opt(:,1),'--k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Neyman-Pearson optimal (brute force)');
hold on;
h4=semilogy(NP_cvx(:,1),'--sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

hold on;

% set(gca,'XTick',K);
% set(gca,'XTickLabel',K);
ylim([0.1 5]);
% grid on;
xlabel('k');  ylabel('pe');
hleg2= legend([h3,h4],'Neyman-Pearson optimal (alpha = 0.01)AAAAAA',...
    'Neyman-Pearson relaxed, randomized (alpha = 0.01)AAAAAAA',...
    'Location','Northoutside');
%legend boxoff;
set(hleg2,'FontSize',16);
set(gca,'Layer','top');
print('-deps', 'rho0p25NP.eps');


%%
close all
%rho = 0.75
figure(3);

set(gca,'Fontsize', 16);
area(Be(:,:,2),'FaceColor',[0.6 0.6 0.6], 'LineStyle','none');
set(gca,'XLim',[1 10])
set(gca,'XTick',[1:10])
set(gca,'XTickLabel',5:14); set (gca, 'Yscale', 'log');
hold on;

h1=semilogy(Bayes_opt(:,2),'k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Bayes optimal (brute force)');
hold on;
h2=semilogy(Bayes_cvx(:,2),'-sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

ylim([10^-4 10]);
hleg2= legend([h1,h2],'Bayes optimal (pi0 = 0.3) ',...
    'Bayes relaxed, randomized (pi0 = 0.3)',...
    'Location','NorthEast');
set(hleg2,'FontSize',16);

set(gca,'Layer','top');
xlabel('k');  ylabel('pe');
legend off;
print('-deps', 'rho0p75Bay.eps');



figure(4);
set(gca,'Fontsize', 16);
area(Bd(:,:,2),'FaceColor',[0.8 0.8 0.8], 'LineStyle','none');
set(gca,'XLim',[1 10])
set(gca,'XTick',[1:10])
set(gca,'XTickLabel',5:14); set (gca, 'Yscale', 'log');
hold on;


h3=semilogy(NP_opt(:,2),'--k','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',8,'DisplayName','Neyman-Pearson optimal (brute force)');
hold on;
h4=semilogy(NP_cvx(:,2),'--sk','LineWidth',1.5,...
    'MarkerEdgeColor','k',...
    'MarkerSize',10,'DisplayName','Convex relaxed sensor selection');

hold on;

% set(gca,'XTick',K);
% set(gca,'XTickLabel',K);
ylim([10^-6 100]);
% grid on;
xlabel('k');  ylabel('pe');
hleg2= legend([h3,h4],'Neyman-Pearson optimal (alpha = 0.01)AA',...
    'Neyman-Pearson relaxed, randomized (alpha = 0.01)AA',...
    'Location','NorthEast');
set(hleg2,'FontSize',16);
set(gca,'Layer','top');
legend off;
print('-deps', 'rho0p75NP.eps');
