%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Article:      Submodular Detection for Correlated Measurements
% Section:      Uncommon Covariance Matrices - Bhat Dist
% Author:       Mario Coutino
% Affiliation:  TU Delft
% Data:         November 2016
% Conference:   N/A
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all, close all

COV_TYPES = {'random', 'toeplitz', 'rtoeplitz', 'diagonal', 'uniform'};

% number of sensors
N = 15;
V = 1:N;

bDiv = nan(N,1);    gBDiv = nan(N,1); gBDiv_inv = nan(N,1);

covType = COV_TYPES{3};
rho = 0.45;
E0 = genCovMat(N,covType) + diag(rand(N,1));
E1 = genCovMat(N,covType) + diag(rand(N,1));
E01 = 0.5*(E0 + E1);

% function handlers
[bF, bG] = sfo_fn_klDiv(E0,E1,0);
bFG = sfo_fn_lincomb({bF,bG},[1,-1]);

a = 0.11;
S0 = E0 - a*eye(N);
S1 = E1 - a*eye(N);
S01 = E01 - a*eye(N);

bGi = sfo_fn_invert(bG,V);
bFi = sfo_fn_invert(bF,V);

for k = 1:N
	fprintf('\nSize of Subset: %d\n',k)
	fprintf('\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')
    fprintf('\n Submodular Optimization... Size of Subset: %d\n', k);
	%    Bhacharyya Distance
	A_bhat = sfo_supsub(bG,bF,V,k);
    A_bhat_inv = sfo_supsub(bGi,bFi,V,k);
	A_bhat_star = sfo_exhaustive_max(bFG,V,k);    
    
    iSet = setdiff(V,A_bhat_inv);
    gBDiv(k) = bFG(A_bhat);
    gBDiv_inv(k) = bFG(iSet);
	bDiv(k) = bFG(A_bhat_star);
    
end
gBDiv_inv = flipdim(gBDiv_inv,1);
% for i = 1:N
%     gBDiv_inv(i) = bFG(A_bhat_inv(end-(i-1):end));
% end
%% plot figures
apFact = 1 - 1/exp(1);

plot(V,bDiv./bDiv,'-ok','linewidth',1.1), hold on
plot(V,gBDiv./bDiv,'-^k','linewidth',1.1), grid on
% plot(V,gBDiv_inv,'-.k','linewidth',1.1), 
plot(V,apFact,'--k','linewidth',1.1)
legend('Exhaustive Search','FwdGreedy','BckGreedy','1-1/e Bound')

