%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Article:      Submodular Detection for Correlated Measurements
% Section:      Uncommon Mean [MonteCarlo]
% Author:       Mario Coutino
% Affiliation:  TU Delft
% Data:         November 2016
% Conference:   N/A
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all, close all

COV_TYPES = {'random', 'toeplitz', 'rtoeplitz', 'uniform', 'diagonal'};

% parameters for simulation
N = 15;
V = 1:N;

V2 = V;
gB = [];

nIt = 1;
nMat = 3;

exSNR = nan(N, nMat, nIt);
tSNR = nan(N, nMat, nIt);
gSNR = nan(N, nMat, nIt);
lSNR = nan(N, nMat, nIt);
giSNR = nan(N, nMat, nIt);
gigSNR = nan(N, nMat, nIt);
cvxSNR = nan(N, nMat, nIt);
worstSNR = nan(N, nMat, nIt);

stp = 5;

for nT = 1%3:nMat
    
    fprintf('\n==================================================\n')
    fprintf('\n Type of matrix %s\n',COV_TYPES{nT})
    fprintf('\n==================================================\n')
    
    for it = 1:nIt
        fprintf('\n Iteration: %d',it)
        fprintf('\n++++++++++++++++++++++++++++++++++++++++++++++++++\n')
        
        % mean vectors
        theta0 = randn(N,1);
        theta1 = randn(N,1);

        % difference vector
        m = theta1 - theta0;

        % covariance matrix
        E = genCovMat(N,COV_TYPES{nT});

        % covariance decomposition
        [S,a,Sinv,ainv] = paramCov(E);
        
        % true cost function
        f = @(A) getSNR(m(A),E(A,A));
        F = sfo_fn_wrapper(f);
        
        fw = @(A) -f(A);
        Fw = sfo_fn_wrapper(fw);
        
        zVec = zeros(N,1);
        
        % submodular surrogate function
        fs = @(A) subMSE(Sinv,a,m,A);
        Fs = sfo_fn_wrapper(fs);
        
        % removing sensors submodular
        FIS = sfo_fn_invert(Fs,V);
        
        % removing sensor true cost
        FI = sfo_fn_invert(F,V);
        
        for k = 1:stp:N
            fprintf('\n Number of Sensors: %d\n\n',k)
            cvx_begin sdp quiet
                variable w(N)
                variable t
                minimize t
                subject to
                sum(w) ==  k;
                [Sinv + ainv*diag(w), m;
                    m' , t] >= semidefinite(N+1);
                w(:)<=1;
                w(:)>=0;
            cvx_end
            
%             [wsel] = randomized_rounding_toeplitz(w,S,k,theta1-theta0);
            [wsel] = randomized_rounding(w,k,f);
            wsel_idx = find(wsel == 1);
    
            cvxSNR(k,nT,it) = m(wsel_idx)'*inv(E(wsel_idx,wsel_idx))*m(wsel_idx);

        end
        
        % greedy for the true cost function
        At = sfo_greedy_k(F,V,N);
        tSNR(:,nT, it) = kSetFunctionCost(F,At');
            
        % greedy for the submodular cost function
        Ag = sfo_greedy_k(Fs,V,N);
        gSNR(:,nT, it) = kSetFunctionCost(F,Ag');
        
    end
    
end
%save('res_uMean_MC_0702','exSNR','tSNR','gSNR','giSNR','gigSNR','cvxSNR')
% save('res_uMean_MC_largSet','exSNR','tSNR','gSNR','giSNR','gigSNR','cvxSNR')
%% Comparison Plots

max_ExSNR = max(exSNR,[],3);
max_TrSNR = max(tSNR,[],3);
max_SuSNR = max(gSNR,[],3);
max_SiSNR = max(giSNR,[],3);
max_TiSNR = max(gigSNR,[],3);

min_ExSNR = min(exSNR,[],3);
min_TrSNR = min(tSNR,[],3);
min_SuSNR = min(gSNR,[],3);
min_SiSNR = min(giSNR,[],3);
min_TiSNR = min(gigSNR,[],3);

mean_ExSNR = nanmean(exSNR,3);
mean_TrSNR = nanmean(tSNR,3);
mean_SuSNR = nanmean(gSNR,3);
mean_SiSNR = nanmean(giSNR,3);
mean_TiSNR = nanmean(gigSNR,3);
mean_CXSNR = nanmean(cvxSNR,3);
mean_SNRworst = nanmean(worstSNR,3);

pi0 = 0.3;
pi1 = 1 - pi0;

gamma_e = log(pi0/pi1);

Pe_BA = @(sw) pi1.*(1 - qfunc(gamma_e./sqrt(sw) - sw./(2.*sqrt(sw)))) + ...
    pi0.*qfunc(gamma_e./sqrt(sw) + sw./(2*sqrt(sw)));

alpha = 0.01;
gamma = qfuncinv(alpha);

thr = @(sw) sw.*qfuncinv(alpha) - sqrt(sw)./2;
P_md = @(sw) 1 - qfunc( (2.*thr(sw) - sw)./(2.*sqrt(sw)) );

close all,
matType = 1;
bnd = (1-1/exp(1));

hfig = area([Pe_BA(mean_SNRworst(:,matType)) ...
    Pe_BA(mean_ExSNR(:,matType))-Pe_BA(mean_SNRworst(:,matType))],'LineStyle','none');
set(hfig(1),'FaceColor',[1 1 1])
set(hfig(2),'FaceColor',[0.9 0.9 0.9])
set(gca,'yscale','log','fontsize',13), hold on,

isEx = 1;
listK = 1:stp:N;

if isEx
    pl1 = semilogy(V,Pe_BA(mean_ExSNR(:,matType)),'-','linewidth',1.1);
end
pl2 = semilogy(V(:),Pe_BA(mean_TrSNR(:,matType)),'-+k','linewidth',1.1);
pl3 = semilogy(V(:),Pe_BA(mean_SuSNR(:,matType)),'-dm','linewidth',1.1);
pl4 = semilogy([V(listK) N],Pe_BA([mean_CXSNR(listK,matType); ...
    mean_SuSNR(end,matType)]),'-og','linewidth',1.1);
if isEx
    pl5 = semilogy(V,Pe_BA(mean_SNRworst(:,matType)),'--','linewidth',1.1);
    legend([pl1; pl2; pl3; pl4; pl5],...
    {'Exhaustive Search', 'Greedy', 'Submodular Surrogate', ...
    'Convex Method','Worst Subset'},'location','sw')
else
    legend([pl2; pl3; pl4],...
    {'Greedy', 'Submodular Surrogate', ...
    'Convex Method'},'location','sw')
end
% pl6 = semilogy(V,mean_ExSNR(:,matType)*bnd,'--k','linewidth',1.1);



xlabel('Number of Sensors [k]')
ylabel('Probability of Error')

%% Histogram Plot

stp = 5;
N = 50;
V = 1:N;
matType = 3;

isEx = 0;
listK = 1:stp:N;

Pcvx = (cvxSNR(listK,matType,1:90)./cvxSNR(listK,matType,1:90));
Pgred = (tSNR(listK,matType,1:90)./cvxSNR(listK,matType,1:90));
Psub = (gSNR(listK,matType,1:90)./cvxSNR(listK,matType,1:90));

H1 = hist(Pgred(:),100);
H2 = hist(Psub(:),100); 

close all
[n,x] = hist(Pgred(:),1e3);
h = bar(x,n/sum(n)*100);
set(h,'facecolor',[0 1 1],'edgecolor','none')
set(get(h,'Children'),'FaceAlpha',0.5)

hold on,
[n,x] = hist(Psub(:),1e3);
h = bar(x,n/sum(n)*100);
set(h,'facecolor',[0 0 1],'edgecolor','none')
set(get(h,'Children'),'FaceAlpha',0.5)
set(gca,'xscale','log','fontsize',13)

legend({'Greedy','Submodular Surrogate'})
xlabel('Ratio of the Solution X/CVX')
ylabel('Percentage of Occurence [%]')
