
function epsilon = epsilonTestSNR(theta,E, q)

    N = size(E,1);
    
    f_snr = @(A) theta(A)'*(E(A,A)\theta(A));
    V = 1:N;
    
    epsilon = nan(q,1);
    
    for qq = 1:q
        
        zEl = 0;
        xTest = randi([0 1], N,1);
        
        while(zEl < 2)
            zX = find(xTest == 0);
            zEl = length(zX);
            indX = randperm(zEl,2);
        end
        
        x_i = zX(indX(1));
        x_j = zX(indX(2));
        
        setTst = V(xTest == 1);
        setTst_i = [setTst x_i];
        setTst_j = [setTst x_j];
        setTst_ij = [setTst_j x_i];
        
        epsilon(qq) = f_snr(setTst_i) - f_snr(setTst) - ...
            f_snr(setTst_ij) - f_snr(setTst_j);
        
    end

    epsilon = epsilon/(f_snr(V));
end