

function Asub = maxGredSubSNR(theta,E,K)

    [N,~] = size(E);
    V = 1:N;
    Asub = nan(1,K);
    a = min(eig(E))/2;
    S = E - a*eye(N);
    
    Sinv = S\eye(N);
    
    M_k = [Sinv      Sinv*theta;
        theta'*Sinv theta'*Sinv*theta];
    
    %% debug
    M_kinv = M_k\eye(N+1);
    
    for kk = 1:K
        
        valMax = -inf;
        iMax = 0;
        
        for ee = V
            tmp = real(log(1+ (a^-1)*M_kinv(ee,ee)));
            if tmp >= valMax
                valMax = tmp;
                iMax = ee;
            end
        end
        Asub(kk) = iMax;
        
        if kk == 1
            w = zeros(N,1);
            w(iMax) = 1;
            M_k = [Sinv+(a^-1)*diag(w)     Sinv*theta;
                theta'*Sinv theta'*Sinv*theta]; 
            M_kinv = M_k\eye(N+1);
        else
            M_kinv = M_kinv - ...
                ( M_kinv(:,iMax)*M_kinv(iMax,:) )/( a + M_kinv(iMax,iMax) );
        end
        
        V = setdiff(V,iMax);
    end
    
end