function Asub = maxSubSNRGreedy(theta,E,K)

    [N,~] = size(E);
    V = 1:N;
    Asub = nan(1,K);
    a = min(eig(E))/2;
    S = E - a*eye(N);
    
    Rinv = 1;
    
    for kk = 1:K
        
        valMax = -inf;
        iMax = 0;
        iMaxSNR = 0;
        valMaxSNR = -inf;
        
        for ee = V
            if kk == 1
                snr_tmp = theta(ee)'*(E(ee,ee)\theta(ee));
                tmp = (a^-1*S(ee,ee)+1)*snr_tmp;
            else
                % rank one update for snr function
                r_e = E(Asub(1:kk-1),ee);
                P_e = E(ee,ee);
                v_e = Rinv*r_e;
                alpha_e = 1/(P_e - r_e'*v_e);
                Rinv_tmp = [Rinv + alpha_e*(v_e*v_e') -alpha_e*v_e;
                            -alpha_e*v_e'   alpha_e];
                A_tmp = [Asub(1:kk-1) ee];
                snr_tmp = theta(A_tmp)'*Rinv_tmp*theta(A_tmp);
                
                vk = a^-1*S(Asub(1:kk-1),ee);
                tmp = (a^-1*S(ee,ee)+1 - vk'*Sinv_k*vk)*snr_tmp;
            end
            
            if tmp >= valMax
                valMax = tmp;
                iMax = ee;
            end
            
            if snr_tmp >= valMaxSNR
                valMaxSNR = snr_tmp;
                iMaxSNR = ee;
            end
        end
        if kk == K
            Asub(kk) = iMaxSNR;
        else
            Asub(kk) = iMax;
        end
        
        if kk == 1
            Sinv_k = (1 + a^-1*S(iMax,iMax))^-1;
            Rinv = E(iMax,iMax)^-1;
        else
            % snr update
            r_e = E(Asub(1:kk-1),iMax);
            P_e = E(iMax,iMax);
            v_e = Rinv*r_e;
            alpha_e = 1/(P_e - r_e'*v_e);
            Rinv = [Rinv + alpha_e*(v_e*v_e') -alpha_e*v_e;
                            -alpha_e*v_e'   alpha_e];
                        
            % det inv matrix update
            ri = a^-1*S(Asub(1:kk-1),iMax);
            vi = Sinv_k*ri;
            alphai = 1/(a^-1*S(iMax,iMax) + 1 - ri'*vi);

            Sinv_k = [Sinv_k + alphai*(vi*vi')  -alphai*vi;
                -alphai*vi'    alphai];
        end
        V = setdiff(V,iMax);
    end
    
end