close all;
load testTimeSNRvsN;
mean_grdTime = nanmean(grdTime(10:10:maxN,:),2);
mean_cvxTime = nanmean(cvxTime(10:10:maxN,:),2);

p1 = semilogy(1:10:maxN,mean_grdTime,'-ob','linewidth',1.1); hold on;
p2 = semilogy(1:10:maxN,mean_cvxTime,'-xr','linewidth',1.1);
set(gca,'FontSize',13)
xlabel('Available Sensors [N]')
ylabel('Time [s]')  
legend([p2;p1], {'Convex Method; K= N/2','Greedy Method; K ={1,...,N}'})
% plotting

figure,
load testTimeSNRvsK;
mean_grdTime = nanmean(grdTime(1:10:N,1:100),2);
mean_cvxTime = nanmean(cvxTime(1:10:N,1:100),2);

p1 = semilogy(1:10:N,mean_grdTime,'-ob','linewidth',1.1); hold on;
p2= semilogy(1:10:N,mean_cvxTime,'-xr','linewidth',1.1);
set(gca,'FontSize',13)
xlabel('Selected Sensors [K]')
ylabel('Time [s]')  
legend([p2;p1], {'Convex Method; N=50','Greedy Method; N=50'})
% plotting



