

function output = testEpsilonBound()

    N = 10;
    theta = randn(N,1);

    E = genCovMat(N,'random');

    a = 0.5*min(eig(E));
    S = E - a*eye(N);
    Z = inv(S);
    ai = a^-1;

    function w = wFun(a)
        if ~isempty(a)
            w = diag(de2bi(a,N));
        else
            w = zeros(N);
        end
    end

    f = @(a) theta'*Z*inv(Z + ai*wFun(a))*Z*theta;

    nComb = 2^N - 1;
    
    I = eye(N);
    lMax = trace(Z*theta*theta'*Z);
    bound = 2*( f(nComb) - trace(inv(Z + ai*I))*lMax);

    fprintf('Bound: %f\n\n',bound)
    
    keyboard()
end