%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Article:      Submodular Detection for Correlated Measurements
% Section:      Uncommon Covariance
% Author:       Mario Coutino
% Affiliation:  TU Delft
% Date:         November 2016
% Conference:   N/A
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all

N = 20;
E = zeros(N,N,2);
E(:,:,1) = genCovMat(N,'rtoeplitz');
E0 = E(:,:,1);
E(:,:,2) = genCovMat(N,'rtoeplitz');
E1 = E(:,:,2);
A = gendatgauss([10*N,10*N],zeros(2,N),E);


[C,D] = gendat(A,0.2);


err2 = nan(N,1);
errSS = nan(N,1);
errGG = nan(N,1);
errGS = nan(N,1);

 % Greedy Heuristic
V = 1:N;
SUB_APPROX = 1;
 % handlers
        [kF, kG] = sfo_fn_klDiv(E0,E1);
        kFG = sfo_fn_lincomb({kF, kG},[1,-1]);
        [kFs, kGs] = sfo_fn_klDiv(E0,E1,SUB_APPROX);
        %%
A_kl = sfo_supsub(kG,kF,V,N);
A_kl_greedy = sfo_greedy_k(kFG,V,N);        
A_kl_s = sfo_supsub(kGs,kFs,V,N);

%%
kVec = 1:5:N;
err2 = nan(N,4);
for kk = kVec;
    
    fprintf('Num. Sensors: %i\n',kk)
    
    % PR Feature Selection
    featSel = A*featseli([],'maha-s',kk);
    prW = C*featSel*qdc;
    err2(kk) = D*featSel*prW*testc;
    
%     W1 = A*featseli([],'NN',kk);     W1 = setname(W1,'ISel NN'); 
%     W2 = A*featseli([],'maha-s',kk); W2 = setname(W2,'ISel maha-s');
%     W3 = A*featseli([],'maha-m',kk); W3 = setname(W3,'ISel maha-m');
%     W4 = A*featseli([],'in-in',kk);  W4 = setname(W4,'ISel in-in');
%     V = C*({W1,W2,W3,W4}*qdc);   % train all selectors and classifiers
%     tmp = D*V*testc;            % show test results
%     err2(kk,:) = tmp;
    
    % Greedy Heuristics
    fSupSub = featsel(N,A_kl(1:kk));
    ssW = C*fSupSub*qdc;
    errSS(kk) = D*fSupSub*ssW*testc;
    
    fGreedy = featsel(N,A_kl_greedy(1:kk));
    ggW = C*fGreedy*qdc;
    errGG(kk) = D*fGreedy*ggW*testc;
    
    fSurr = featsel(N,A_kl_s(1:kk));
    gsW = C*fSurr*qdc;
    errGS(kk) = D*fSurr*gsW*testc;

end
%%
figure; hold on;
p1 = plot([1 kVec],100*err2([1 kVec],:)','-o');
p2 = plot([1 kVec],100*errSS([1 kVec]),'-sr');
p3 = plot([1 kVec],100*errGG([1 kVec]),'-dg');
p4 = plot([1 kVec],100*errGS([1 kVec]),'-xk');
grid on
set(gca,'fontsize',13,'yscale','log')
legend([p1;p2;p3;p4],{'PRTools','SupSub','KL Greedy','Surrogate'})
xlabel('Number of Sensors [K]')
ylabel('Classification Error')


