clear all,
close all,
clc;

    % the parameters
numSen = 10;
Kappa = [1 10 1e2 1e3];
alpha = 1;
typeMtx = 'rndmtx';

    % the set
V = 1:numSen;

%     % generate powerset
combnz = cell(numSen,1);    
for nn = 1:numSen
        % all the combinations taken nn items at a time
    combnz{nn} = combnk(V,nn);
end
numTries = 1e2;

mean_ep = nan(length(Kappa),1);
for kk = 1:length(Kappa)
    kappa = Kappa(kk);
    fprintf('Kappa: %f\n\n',kappa);
    max_ep = nan(numTries,1);
    for nn = 1:numTries 
        if mod(nn,10) == 0
            fprintf('Tries: %f\n',nn);
        end
        switch(typeMtx)
            case 'toep'
                Toep = gallery('toeppd',numSen);
                [U,E] = eig(Toep);
                E = diag(linspace(1/kappa,1,numSen));
                E = E + diag([0, 1/(numSen+1)*randn(1,numSen-2), 0]);
                Sigma = U*E*U';
            case 'rndmtx'
                Rmtx = gallery('randsvd',numSen,sqrt(kappa)); R = Rmtx*Rmtx';
                Sigma = R;
        end

        x = randn(numSen,1);

            % the function
        fn_snr = @(A) x(A)'*(Sigma(A,A)\x(A));


        maxIt = 10e3;
        epsilon = nan(maxIt,1);
        for it = 1:maxIt
            numBag = randperm(numSen-2,1);
            bags = combnz{numBag};
            bagA = bags(randperm(length(bags),1),:);
            num2add = numSen - 1 - numBag;
            addNums = randperm(num2add,1);
    
            setCom = setdiff(V,bagA);
            bagB = [bagA setCom(randperm(length(setCom),addNums))];
    
            j = setdiff(V,bagB);
    
            epsilon(it) = fn_snr([bagB j]) - fn_snr(bagB) - fn_snr([bagA j]) + ...
                fn_snr(bagA);
        end
        max_ep(nn) = max(epsilon)/fn_snr(V);
    end
    mean_ep(kk) = mean(max_ep);
end
set(gca,'FontSize',13)
plot(Kappa, mean_ep,'LineWidth',1.1);
xlabel('\kappa')
ylabel('r_\kappa')
% for it = 1:maxIt
%     a_t = ones(numSen,1);
%     while( sum(a_t) >= numSen-1 )
%         a_t = randi([0 1], numSen,1);
%     end
%     zIndx = (V(a_t == 0));
%     b_t = a_t;
%     indx2add = randperm(length(zIndx),2);
%     b_t(zIndx(indx2add(1))) = 1;
%     
%     j = zIndx(indx2add(2));
%     
%     At = V(a_t==1);
%     Bt = V(b_t==1);
%     epsilon(it) = fn_snr([Bt j]) - fn_snr(Bt) - fn_snr([At j]) + ...
%         fn_snr(At);
% end

